static char *RCSid = "$Header: upgr.c 1.5 89/03/17 $";

/*
 * upgr.c
 *
 * upgrade tech of ships.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "nat.h"
#include "nsc.h"

upgr()
{
	extern	char *fmt();
	extern	int cnum;
	extern	struct sctstr sect;
	extern	int owner;
	extern	char *argp[];
	extern	struct natstr *natp;
	extern	double dolcost;
	extern	struct mchrstr mchr[];
	struct	nbstr nb;
	struct	shpstr ship;
	struct	mchrstr *mp;
	int	n;
	int	tlev;
	int	workforce;

	if (snxtshp(&nb, argp[1], cnum, "Ship(s)? ") == -1)
		return RET_SYN;
	tlev = natp->nat_level[NAT_TLEV];
	for (n=0; nxtshp(&nb, &ship); n++) {
		getsect(ship.shp_x, ship.shp_y);
		if (!owner || sect.sct_type != SCT_HARBR || sect.sct_effic < 60)
			continue;
		workforce = gsctv(V_CIVIL) * sect.sct_work / 100;
		workforce += gsctv(V_UW) + gsctv(V_MILIT) * 2 / 5;
		mp = &mchr[ship.shp_type];
		if (workforce < (mp->m_lcm + 2 * mp->m_hcm) / 2) {
			pr(fmt("Workforce at %d,%d is too small for upgrade.\n",
				xwrap(ship.shp_x), ywrap(ship.shp_y)));
			continue;
		}
		if (ship.shp_effic < 60) {
			pr(fmt("%s #%d is too damaged to upgrade!\n",
				mp->m_name, nb.nb_sno));
			continue;
		}
		ship.shp_effic -= 35;
		ship.shp_tech = tlev;
		putship(ship.shp_uid, &ship);
		dolcost += mp->m_cost / 2;
	}
	if (n == 0) {
		pr("No ships\n");
		return RET_SYN;
	}
	return RET_OK;
}
