static char *RCSid = "$Header: torp.c,v 1.5 89/02/26 18:06:52 muir Locked $";

/*
 * $Log:	torp.c,v $
 * Revision 1.5  89/02/26  18:06:52  muir
 * arthur patch 14: torps sometimes miss now
 * 
 * Revision 1.4  89/02/11  15:59:21  muir
 * after mr-frog changes
 * 
 * Revision 1.3  88/04/01  04:48:00  muir
 * rcsid now at top
 * 
 */

/*
 * torp.c
 *
 * fire torpedoes at enemy shipping.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "news.h"

torp()
{
	extern	double tfact();
	extern	char *fmt();
	extern	char *argp[];
	extern	struct mchrstr mchr[];
	extern	int cnum;
	register int r11;
	register int r10;
	int	dsq;
	int	countdown;
	int	dam;
	int	shells;
	int	subno;
	int	victno;
	double	erange;
	double	hitchance;
	struct	shpstr vship;
	struct	shpstr sub;
	struct	shpstr dd;

	if ((victno = getshno(argp[1], "Victim ship #? ", &vship)) < 0)
		return RET_SYN;
	if ((subno = getshno(argp[2], "From sub #", &sub)) < 0)
		return RET_SYN;
	if (sub.shp_own != cnum) {
		pr("Not your sub, dingaling\n");
		return RET_FAIL;
	}
	if ((mchr[sub.shp_type].m_flags & M_TORP) == 0) {
		pr(fmt("A %s can't fire torpedoes!\n",
			mchr[sub.shp_type].m_name));
		return RET_FAIL;
	}
	shells = gshpv(V_SHELL, &sub);
	if (gshpv(V_GUN, &sub) == 0 || shells < 3) {
		pr("Insufficient armament\n");
		return 1;
	}
	if (sub.shp_effic < 60) {
		pr("Torpedo tubes inoperative.\n");
		return 1;
	}
	if (sub.shp_mobil <= 0) {
		pr("Insufficient mobility\n");
		return 1;
	}
	if (vship.shp_own && trechk(cnum, vship.shp_own, 2) < 0)
		return 1;
	sigsave();
	erange = sub.shp_effic * tfact(cnum, 2.0) / 100.0;
	pr(fmt("Effective torpedo range is %.1f\n", erange));
	erange *= erange;
	pshpv(V_SHELL, shells - 3, &sub);
	sub.shp_mobil -= 20;
	putship(subno, &sub);
	pr("Blooop... ");
	getship(victno, &vship);
	r10 = vship.shp_own;
	dsq = mapdsq(sub.shp_x, sub.shp_y, vship.shp_x, vship.shp_y);
	if (dsq <= 5)
		countdown = dsq + 4;
	else
		countdown = 9;
	while (countdown) {
		pr(fmt("%d... ", countdown));
		sleep(1);
		countdown--;
	}
	hitchance = 0.90 / ((dsq * 3) + 1);
	if (dsq > erange) {
		pr("Out of range\n");
	} else if (chance(hitchance)) {
		pr("BOOM!...\n");
		wu(0, r10, fmt("%s #%d @%s torpedoed %s %d",
			mchr[sub.shp_type].m_name,
			subno, xytoa(sub.shp_x, sub.shp_y, r10),
			mchr[vship.shp_type].m_name, victno));
		dam = 50 + (rand() % 50);
		dam = (100 * dam) / (mchr[vship.shp_type].m_armor + 50);
		shipdamage(&vship, dam);
		putship(victno, &vship);
		nreport(r10, N_TORP_SHIP, 0, 1);
	} else {
		pr("Missed\n");
		wu(0, r10, fmt("Torpedo sighted @%s by %s #%d",
			xytoa(sub.shp_x, sub.shp_y, r10),
			mchr[vship.shp_type].m_name, victno));
	}
	for (r11 = 0; getship(r11, &dd) == 0; r11++) {
		if (dd.shp_own != r10)
			continue;
		if ((mchr[dd.shp_type].m_flags & M_DCH) == 0)
			continue;
		if (dd.shp_x != sub.shp_x)
			continue;
		if (dd.shp_y != sub.shp_y)
			continue;
		if ((shells = gshpv(V_SHELL, &dd)) < 2)
			continue;
		if (gshpv(V_GUN, &dd) < 1)
			continue;
		pr("\nCAPTAIN!  !!Depth charges!!...\n");
		nreport(r10, N_FIRE_BACK, cnum, 1);
		wu(0, r10,
			fmt("Destroyer #%d dropped a depth charge on sub #%d",
			r11, subno));
		pshpv(V_SHELL, shells - 2, &dd);
		putship(r11, &dd);
		dam = (rand() % 30) + 30;
		getship(subno, &sub);
		shipdamage(&sub, dam);
		putship(subno, &sub);
		if (sub.shp_own == 0)
			break;
	}
	return 0;
}
