#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/tend.c,v 1.4 89/03/07 16:50:01 muir Exp $";
#endif

/*
 * tend.c
 *
 * transfer from one ship to another
 * Hacked to provide a bulk-rate tend ability.
 * which doesn't prompt for each commodity transferred to
 * each ship.
 *
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "item.h"
#include "nsc.h"

int
tend()
{
	extern struct ichrstr *whatitem();
	extern char *fmt();
	extern char *getstarg();
	extern char *argp[];
	extern int cnum;
	extern struct mchrstr mchr[];
	extern int god;
	int     tender_num;
	int     barometer;
	struct shpstr tender;
	struct shpstr theship;
	struct nbstr nb;
	struct ichrstr *ip;
	int     amt;
	int     ontender;
	int     ontarget;
	int     maxtender;
	int     maxtarget;
	int     transfer;
	int     total;

	tender_num = getshno(argp[1], "Tender? ", &tender);
	if (tender_num == -1) {
		pr("Designate one ship\n");
		return RET_SYN;
	}
	if (tender.shp_own != cnum && !god) {
		pr("Not your ship\n");
		return RET_SYN;
	}
	barometer = wethr(tender.shp_y, tender.shp_x, 0);
	if (barometer < 730) {
		pr(fmt("Barometer @%d;  Seas too rough\n", barometer));
		return RET_SYN;
	}
	if ((ip = whatitem(argp[2], "Transfer what item? ")) == 0)
		return RET_SYN;
	if ((amt = atoi(getstarg(argp[3], "Amount to transfer? "))) == 0)
		return RET_SYN;
	if ((ontender = gshpv(ip->i_vtype, &tender)) == 0 && amt > 0) {
		pr(fmt("No %s on ship %d\n", ip->i_name, tender_num));
		return RET_FAIL;
	}
	maxtender = getvar(ip->i_vtype, &mchr[tender.shp_type], GT_MCHR);
	if (maxtender == 0) {
		pr(fmt("A %s cannot hold any %s\n",
		       mchr[tender.shp_type].m_name,
		       ip->i_name));
		return RET_FAIL;
	}
	if (snxtshp(&nb, argp[4], cnum, "Ships to be tended? ") < 0)
		return RET_SYN;
	sigsave();
	total = 0;
	while (nxtshp(&nb, &theship)) {
		if (nb.nb_sno == tender_num && !god)
			continue;
		if (tender.shp_x != theship.shp_x || tender.shp_y != theship.shp_y) {
			pr("Deck hands can't throw cargo that far");
			return RET_FAIL;
		}
		ontarget = gshpv(ip->i_vtype, &theship);
		maxtarget = getvar(ip->i_vtype, &mchr[theship.shp_type], GT_MCHR);
		if (amt < 0) {
			/*
			 * take from ship and give to
			 * tender
			 */
			transfer = min(ontarget, -amt);
			transfer = min(maxtender - ontender, transfer);
			if (transfer == 0)
				continue;
			pshpv(ip->i_vtype, ontarget - transfer, &theship);
			ontender += transfer;
			total += transfer;
		} else {
			/*
			 * give to ship from tender
			 */
			transfer = min(ontender, amt);
			transfer = min(transfer, maxtarget - ontarget);
			if (transfer == 0)
				continue;
			pshpv(ip->i_vtype, ontarget + transfer, &theship);
			ontender -= transfer;
			total += transfer;
		}
		if (gshpv(V_PSTAGE, &tender) == PLG_INFECT &&
		    gshpv(V_PSTAGE, &theship) == PLG_HEALTHY)
			pshpv(V_PSTAGE, PLG_EXPOSED, &theship);
		if (gshpv(V_PSTAGE, &theship) == PLG_INFECT &&
		    gshpv(V_PSTAGE, &tender) == PLG_HEALTHY)
			pshpv(V_PSTAGE, PLG_EXPOSED, &tender);
		putship(nb.nb_sno, &theship);
		if (amt > 0 && ontender == 0) {
			pr(fmt("%s #%d out of %s\n",
			       mchr[tender.shp_type].m_name,
			       tender_num, ip->i_name));
			break;
		}
	}
	pr(fmt("%d total %s transferred\n", total, ip->i_name));
	pshpv(ip->i_vtype, ontender, &tender);
	putship(tender_num, &tender);
	sigrest();
	return RET_OK;
}
