#ifndef lint
static char *RCSid = "$Header: surv.c 1.6 89/03/17 $";
#endif

/*
 * surv.c
 *
 * show sector survey div 10
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"

/*
 * survey type <sarg> ?cond
 *
 */
surv()
{
	extern struct sctstr sect;
	extern char *fmt();
	char    code_char();
	extern char *argp[];
	extern int cnum;
	extern int lx, ly, hx, hy;
	extern int ix, iy;
	extern struct dchrstr dchr[];
	extern int god;
	extern char *condarg;
	int     nsect;
	struct nstr nstr;
	int     off;
	int     type;
	int     y;
	int     x;
	int     do_nxtsct;
	long    coding;

	nsect = 0;
	do_nxtsct = 0;
	if (encode(argp[1], &coding, 0) < 0)
		return RET_SYN;
	if (snxtsct(&nstr, argp[2]) < 0)
		return 2;
	if (condarg == 0)
		condarg = "own>0";
	if (!god)
		snxtsct_own(&nstr, cnum);
	do_nxtsct = nxtsct(&nstr, 0);
	border(lx, hx, ix, "    ", "");
	for (y = ly; y < hy; y += iy) {
		pr(fmt("%3d ", y));
		for (x = lx; x < hx; x += ix) {
			if ((x + y) & 01) {
				pr(" ");
				continue;
			}
			off = sctoff(x, y);
			if (sctown(off) != cnum && !god) {
				pr(" ");
				continue;
			}
			type = sctdes(off);
			if (do_nxtsct && nstr.n_x == x && nstr.n_y == y) {
				pr_hilite(fmt("%c", code_char(coding, &sect)));
				do_nxtsct = nxtsct(&nstr, 0);
				nsect++;
			} else
				pr(fmt("%c", dchr[type].d_mnem));
		}
		pr(fmt(" %d\n", y));
	}
	border(lx, hx, ix, "    ", "");
	if (condarg)
		pr(fmt("\n%d sector%s.\n", nsect, splur(nsect)));
	return RET_OK;
}

char
code_char(coding, sp)
	long    coding;
	struct sctstr *sp;
{
	extern struct dchrstr dchr[];
	int     amt;
	int     n;

	amt = decode(coding, (char *) sp, GT_SECT);
	n = 0;
	if ((coding & NSC_CMASK) == NSC_VAR) {
		if (amt != 0)
			n = (amt / 100) + 1;
	} else if (amt != 0)
		n = (amt / 10) + 1;
	if (n > 11)
		n = 11;
	if (n < 0)
		n = 0;
	return " 0123456789$"[n];
}
