#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/show.c,v 1.5 89/03/07 16:49:53 muir Exp $";
#endif

/*
 * show - give info on empire internal data structures - e.g.
 * 	planes, boats, nukes etc.
 *
 * Julian Onions, 1988
 */

#include "misc.h"

show()
{
	extern char *argp[];
	extern char *getstarg();
	extern int show_nuke_build(), show_nuke_capab(), show_plane_build(), show_plane_capab(), show_ship_build(), show_ship_capab();
	char   *p;
	int     (*cfunc) (), (*bfunc) ();

	p = getstarg(argp[1], "Describe what (plane, nuke, bridge, ship)? ");

	switch (*p) {
	case 'b':
		show_bridge(99999);
		return RET_OK;
	case 'n':
		bfunc = show_nuke_build;
		cfunc = show_nuke_capab;
		break;
	case 'p':
		bfunc = show_plane_build;
		cfunc = show_plane_capab;
		break;
	case 's':
		bfunc = show_ship_build;
		cfunc = show_ship_capab;
		break;
	default:
		pr(fmt("I don't know about %s's\n", p));
		return RET_SYN;
	}
	p = getstarg(argp[2], "Build data or capability data (b or c)? ");
	if (*p == 'B' || *p == 'b')
		(*bfunc) (99999);
	else if (*p == 'C' || *p == 'c')
		(*cfunc) (99999);
	return RET_OK;
}
