#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/shoo.c,v 1.6 89/03/07 16:49:51 muir Exp $";
#endif

/*
 * shoo.c
 *
 * shoot some conquered populace or uw.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "news.h"
#include "item.h"

shoo()
{
	extern struct ichrstr *whatitem();
	extern char *getstarg();
	extern char *fmt();
	extern char *argp[];
	extern int cnum;
	extern struct sctstr sect;
	extern int diroff[][2];
	extern int owner;
	int     uw;
	int     mil;
	int     nuw;
	struct nstr nstr;
	int     nshot;
	int     mob_cost;
	struct ichrstr *ip;

	if (snxtsct(&nstr, argp[1]) == -1)
		return RET_SYN;
	getnat(cnum);
	ip = whatitem(argp[2], "Shoot what <civ or uw>");
	if (ip == 0 || (ip->i_vtype != V_CIVIL && ip->i_vtype != V_UW))
		return RET_SYN;
	nuw = atoi(getstarg(argp[2], fmt("number of %s to shoot (max 999)? ",
					 ip->i_name)));
	if (nuw < 0)
		return 1;
	if (nuw > 999)
		nuw = 999;
	sigsave();
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		uw = gsctv(ip->i_vtype);
		if (uw == 0)
			continue;
		mil = gsctv(V_MILIT);
		/*
		 * if military control, ok to shoot.
		 */
		if (uw > mil * 10)
			continue;
		nshot = uw > nuw ? nuw : uw;
		mob_cost = nshot / 5;
		if (mob_cost > sect.sct_mobil) {
			nshot = sect.sct_mobil * 5;
			mob_cost = sect.sct_mobil;
		}
		if (nshot <= 0)
			continue;
		sect.sct_mobil -= mob_cost;
		uw -= nshot;
		pr(fmt("BANG!! (thump) %d %s%s shot in %d,%d!\n",
		       nshot, ip->i_name, splur(nshot),
		       sect.sct_x, sect.sct_y));
		if (uw <= 0 && ip->i_vtype == V_CIVIL) {
			if (sect.sct_own != sect.sct_oldown) {
				sect.sct_oldown = sect.sct_own;
				pr(fmt("  %d,%d is now completely yours\n",
				       sect.sct_x, sect.sct_y));
			}
		}
		if (chance(nshot / 100.0))
			nreport(cnum, N_SHOOT_CIV, sect.sct_oldown, 1);
		psctv(ip->i_vtype, uw);
		putsect(nstr.n_x, nstr.n_y);
	}
	sigrest();
	return RET_OK;
}
