static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/shi.c,v 1.8 89/05/10 01:58:15 muir Exp $";

/*
 * shi.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

shi()
{
	extern	char *argp[];
	int	nships;
	struct	nstr_item ni;
	struct	shpstr ship;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;
	nships = 0;
	while (nxtitem(&ni, (char *)&ship)) {
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
				ship.shp_type, ni.cur));
			continue;
		}
		if (nships++ == 0) {
pr("shp#     ship type      x,y   flt eff  civ  mil   uw food  pln  mob  tech\n");
		}
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", mchr[ship.shp_type].m_name));
		pr(fmt("%s ", xyas(ship.shp_x, ship.shp_y, cnum)));
		pr(fmt(" %1c ", ship.shp_fleet));
		pr(fmt("%4d%%", ship.shp_effic));

		getvec(VT_ITEM, (char *)&ship, EF_SHIP, vec);
		pr(fmt("%4d", vec[I_CIVIL]));
		pr(fmt("%5d", vec[I_MILIT]));
		pr(fmt("%5d", vec[I_UW]));
		pr(fmt("%5d", vec[I_FOOD]));

		pr(fmt("%5d", ship.shp_nplane));
		pr(fmt("%5d", ship.shp_mobil));
		pr(fmt("%6d\n", ship.shp_tech));
	}
	if (nships == 0) {
		pr(fmt("%s: No ship(s)\n", (argp[1] == 0) ? "" : argp[1]));
		return RET_FAIL;
	}
	pr(fmt("%d ship%s\n", nships, splur(nships)));
	return RET_OK;
}
