#ifndef lint
static char *RCSid = "$Header: sell.c 1.7 89/03/17 $";
#endif

/*
 * sell.c
 *
 * engage in inter-nation trading of commodities.
 * Place commodities on-sale at the deity trading post.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "nsc.h"
#include "trade.h"

/*
 * format: sell <COMMODITY> <SECTS> <NUMBER> <PRICE>
 *   where NUMBER represents either the number to reach
 *   or, if negative, the abs number to try and get from
 *   each sector.
 */
sell()
{
	extern struct ichrstr *whatitem();
	extern char *getstarg();
	extern char *fmt();
	extern double atof();
	extern char *argp[];
	extern struct sctstr sect;
	extern double dolcost;
	extern int owner;
	extern int cnum;
	extern int god;
	struct nstr nstr;
	int     number_set;
	int     number_sub;
	struct ichrstr *ip;
	int     product;
	int     totalcom;
	int     amt;
	int     com;
	char   *p;
	float   price;

	if ((ip = whatitem(argp[1], "Commodity to sell : ")) == 0)
		return RET_SYN;
	if (ip->i_sell == 0) {
		pr(fmt("You can't sell %s\n", ip->i_name));
		return RET_SYN;
	}
	product = ip->i_vtype & ~VT_TYPE;
	if (snxtsct(&nstr, argp[2]) < 0)
		return RET_SYN;
	number_set = 0;
	number_sub = 0;
	if ((p = getstarg(argp[3], "amount :  ")) == 0 || *p == 0)
		return RET_SYN;
	number_set = atoi(p);
	if (number_set < 0) {
		number_sub = -number_set;
		number_set = 0;
	}
	if ((p = getstarg(argp[4], "price : ")) == 0 || *p == 0)
		return RET_SYN;
	price = atof(p);
	if (price < 0.0)
		return RET_SYN;
	totalcom = 0;
	sigsave();
	while (nxtsct(&nstr, 0) > 0) {
		if (!owner && !god)
			continue;
		/*
		 * military control necessary to sell
		 * goodies in occupied territory.
		 */
		if (sect.sct_oldown != cnum) {
			if (gsctv(V_MILIT) * 10 < gsctv(V_CIVIL))
				continue;
		}
		if ((amt = gsctv(ip->i_vtype)) == 0)
			continue;
		if (number_sub)
			com = min(number_sub, amt);
		else
			com = amt - number_set;
		if (com <= 0)
			continue;
		totalcom += com;
		amt -= com;
		pr(fmt("sold %d %s in %d,%d (%d)\n",
		       com, ip->i_name,
		       xwrap(sect.sct_x), ywrap(sect.sct_y), amt));
		psctv(ip->i_vtype, amt);
		putsect(sect.sct_x, sect.sct_y);
	}
	if (totalcom > 0) {
		/* XXX should use packing */
		dolcost += (double) (totalcom * ip->i_lbs / 10);
		commlock();
		commread();
		commset(cnum, product, totalcom);
		commprice(product, &price);
		commwrite();
		communlock();
		pr(fmt("Total %s put on the market : %d\n", ip->i_name,
		       totalcom));
		pr(fmt("item unit cost : %8.2f\n", price));
	}
	sigrest();
	return RET_OK;
}
