#ifndef lint
static char *RCSid = "$Header: sect.c 1.5 89/03/17 $";
#endif

/*
 * sect.c
 *
 * show sectors in map-like format with conditionals.  All sectors
 * matching are shown as caps.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"

sct()
{
	extern char *fmt();
	extern char *argp[];
	extern int cnum;
	extern int lx, ly, hx, hy;
	extern int ix, iy;
	extern struct dchrstr dchr[];
	extern int god;
	extern char *condarg;
	int     nsect;
	struct nstr nstr;
	int     off;
	int     type;
	int     y;
	int     x;
	int     do_nxtsct;

	nsect = 0;
	do_nxtsct = 0;
	if (snxtsct(&nstr, argp[1]) < 0)
		return RET_SYN;
	if (condarg) {
		if (!god)
			snxtsct_own(&nstr, cnum);
		do_nxtsct = nxtsct(&nstr, 0);
	}
	border(lx, hx, ix, "    ", "");
	for (y = ly; y < hy; y += iy) {
		pr(fmt("%3d ", y));
		for (x = lx; x < hx; x += ix) {
			if ((x + y) & 01) {
				pr(" ");
				continue;
			}
			off = sctoff(x, y);
			if (sctown(off) != cnum && !god) {
				pr(" ");
				continue;
			}
			type = sctdes(off);
			if (do_nxtsct && nstr.n_x == x && nstr.n_y == y) {
				pr_hilite(fmt("%c", dchr[type].d_mnem));
				do_nxtsct = nxtsct(&nstr, 0);
				nsect++;
			} else
				pr(fmt("%c", dchr[type].d_mnem));
		}
		pr(fmt(" %d\n", y));
	}
	border(lx, hx, ix, "    ", "");
	if (condarg)
		pr(fmt("\n%d sector%s.\n", nsect, splur(nsect)));
	return RET_OK;
}
