#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/sate.c,v 1.4 89/03/07 16:49:41 muir Exp $";
#endif

/*
 * sate.c
 *
 * do satellite maps/reports
 *
 * Edward M. Rynes Esq.
 */

#include "misc.h"
#include "var.h"
#include "plane.h"
#include "sect.h"
#include "nsc.h"

sate()
{
	extern double tfact();
	extern double techfact();
	extern char *getstarg();
	extern char *fmt();
	extern char *argp[];
	extern int cnum;
	char   *f4;
	double  tech;
	struct nbstr nbstr;
	struct plnstr plane;

	f4 = getstarg(argp[1], "Satellite? ");
	if (snxtpln(&nbstr, f4, cnum, "from satellite(s)? ") < 0) {
		pr("Specify at least one satellite\n");
		return RET_SYN;
	}
	while (nxtpln(&nbstr, &plane)) {
		if ((plane.pln_flags & PLN_LAUNCHED) && plane.pln_mobil == 127) {
			if (plchr[plane.pln_type].pl_flags & P_S)
				pr("Satellite Spy Report:\n");
			else
				pr("Satellite Map Report:\n");
			pr(fmt("%s #%d at ", plchr[plane.pln_type].pl_name,
			       nbstr.nb_sno));
			tech = techfact(plane.pln_tech, 20.0);
			satmap(plane.pln_x, plane.pln_y, plane.pln_effic, tech,
			       plchr[plane.pln_type].pl_flags);
		}
	}
	return RET_OK;
}
