#ifndef lint
static char *RCSid = "$Header: rout.c 1.6 89/03/17 $";
#endif

/*
 * rout.c
 *
 * Show empire delivery routes and (formerly) contracts
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"

char   *dc[7][2] = {
	"   ", "$ $",
	"  /", "$ /",
	"  >", "$ >",
	"  \\", "$ \\",
	"/  ", "/ $",
	"<  ", "< $",
	"\\  ", "\\ $"
};

int
rout()
{
	extern struct ichrstr *whatitem();
	extern char *copy();
	extern char *fmt();
	extern char *argp[];
	extern int lx, ly, hx, hy;
	extern int ix, iy;
	extern struct dchrstr dchr[];
	extern struct sctstr sect;
	extern int owner;
	register int x;
	register int y;
	register char *buf_ptr;
	register int direction;
	register struct ichrstr *istr;
	char    buffer[133];
	int     i_del;

	if (sargs(argp[2]) == -1)
		return RET_SYN;
	if ((hx - lx) * ix > 62) {
		pr(fmt("Max width (in sectors) is %d", 62));
		return RET_SYN;
	}
	istr = whatitem(argp[1], "item? ");
	if (istr == 0)
		return RET_SYN;
	i_del = V_DEL(istr->i_vtype & ~VT_TYPE);
	border(lx, hx, ix, "    ", " ");
	for (y = ly; y != hy; y += iy) {
		buf_ptr = buffer;
		if (((lx ^ y) & 1) != 0)
			*buf_ptr++ = ' ';
		for (x = lx; x != hx; x += ix) {
			if ((x ^ y) & 01) {
				*buf_ptr++ = ' ';
				continue;
			}
			if (getsect(x, y) != -1 && owner != 0) {
				direction = gsctv(i_del) & 0x7;
				if (!gsctv(V_DIST(istr->i_vtype & ~VT_TYPE)))
					buf_ptr = copy(dc[direction][0], buf_ptr);
				else
					buf_ptr = copy(dc[direction][1], buf_ptr);
				buf_ptr[-2] = dchr[sect.sct_type].d_mnem;
				continue;
			}
			*buf_ptr++ = ' ';
			*buf_ptr++ = ' ';
			*buf_ptr++ = ' ';
		}
		if (((hx ^ y) & 1) == 0)
			*buf_ptr++ = ' ';
		*buf_ptr = 0;
		pr(fmt("%3d %s %d\n", y, buffer, y));
	}
	border(lx, hx, ix, "    ", " ");
	return RET_OK;
}
