#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/repa.c,v 1.6 89/03/07 16:49:35 muir Exp $";
#endif

/*
 * repa.c
 *
 * repay loan from country
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "loan.h"
#include "news.h"

int
repa()
{
	extern char *fmt();
	extern double dolcost;
	extern char *argp[];
	extern struct lonstr loan;
	extern int cnum;
	extern struct natstr *natp;
	register int loan_num;
	register long payment;
	register long owe;
	register long due;
	register long last_payment;
	register long normaltime;
	register long doubletime;
	double  rate_per_sec;
	long    now;

	loan_num = onearg(argp[1], "repay loan #");
	if (loan_num == -1)
		return RET_SYN;
	if (getloan(loan_num) < 0 || loan.l_lonee != cnum || loan.l_ldur == 0) {
		pr("You don't owe anything on that loan...\n");
		return RET_FAIL;
	}
	(void) time(&now);
	due = loan.l_duedate;
	last_payment = loan.l_lastpay;
	if (now < due) {
		normaltime = now - last_payment;
		doubletime = 0;
	}
	if (last_payment < due && due < now) {
		normaltime = due - last_payment;
		doubletime = now - due;
	}
	if (due < last_payment) {
		normaltime = 0;
		doubletime = now - last_payment;
	}
	rate_per_sec = (double) loan.l_irate /
	    ((double) loan.l_ldur * 8640000.0);
	owe = (double) loan.l_amtdue *
	    ((double) normaltime * rate_per_sec + 1.0 +
	     (double) doubletime * rate_per_sec * 2.0) + 0.5;
	payment = onearg(argp[2],
			 fmt("You presently owe $%d; payment : $", owe));
	if (payment > owe || payment < 0) {
		pr("You don't owe that much...\n");
		return RET_FAIL;
	}
	if (payment == 0)
		return RET_SYN;
	if (natp->nat_money < payment) {
		pr(fmt("You only have $%d...\n", natp->nat_money));
		return RET_FAIL;
	}
	sigsave();
	dolcost += payment;
	NAT_DELTA(nat_money, loan.l_loner, payment);
	time(&loan.l_lastpay);
	if (owe <= payment) {
		wu(0, loan.l_loner, fmt("Country #%d paid off loan %d with $%d",
					cnum, loan_num, payment));
		nreport(cnum, N_REPAY_LOAN, loan.l_loner, 1);
		loan.l_ldur = 0;
		pr("Congratulations, you've paid off the loan!\n");
	} else {
		wu(0, loan.l_loner,
		   fmt("Country #%d paid $%.2f on loan %d", cnum,
		       (double) payment, loan_num));
		loan.l_amtdue = owe - payment;
		loan.l_amtpaid += payment;
	}
	putloan(loan_num);
	return RET_OK;
}
