#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/rada.c,v 1.5 89/03/07 16:49:29 muir Exp $";
#endif

/*
 * rada.c
 *
 * do radar from ship or sector
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "nsc.h"

rada()
{
	extern double tfact();
	extern double techfact();
	extern char *getstarg();
	extern char *fmt();
	extern char *argp[];
	extern struct mchrstr mchr[];
	extern int cnum;
	extern int owner;
	extern struct sctstr sect;
	extern struct shpstr ship;
	char   *cp;
	double  tf;
	double  tech;
	struct nstr nstr;
	struct nbstr nbstr;

	cp = getstarg(argp[1], "From? ");
	if (landorsea(cp) == LAND) {
		if (snxtsct(&nstr, cp) < 0)
			return RET_SYN;
		tech = tfact(cnum, 8.0);
		while (nxtsct(&nstr, 0)) {
			if (sect.sct_type != SCT_RADAR)
				continue;
			if (!owner && chkok("") != 0)
				continue;
			radmap(nstr.n_x, nstr.n_y, sect.sct_effic, tech * 2.0, 0.0);
		}
	} else {
		if (snxtshp(&nbstr, cp, cnum, "from ship(s)? ") < 0) {
			pr("Specify at least one ship\n");
			return RET_SYN;
		}
		while (nxtshp(&nbstr, &ship)) {
			if (mchr[ship.shp_type].m_flags & M_SONAR)
				tf = techfact(ship.shp_tech, 1.0);
			else
				tf = 0.0;
			pr(fmt("%s #%d at ", mchr[ship.shp_type].m_name,
			       nbstr.nb_sno));
			tech = techfact(ship.shp_tech,
					(double) mchr[ship.shp_type].m_vrnge);
			radmap(ship.shp_x, ship.shp_y, ship.shp_effic, tech, tf);
		}
	}
	return RET_OK;
}
