#ifndef lint
static char *RCSid = "$Header: prod.c 1.14 89/03/17 $";
#endif

/*
 * prod.c
 *
 * calculate production levels.
 *
 * David Muir Sharnoff, 1987.
 */

#include "misc.h"
#include "var.h"
#include "nsc.h"
#include "sect.h"
#include "product.h"
#include "nat.h"
#include "tm.h"
#include "update.h"
#include "item.h"

int
prod()
{
	extern char *argp[];
	extern char *fmt();
	extern struct ichrstr ichr[];
	extern int maxitem;
	extern int cnum;
	extern int owner;
	extern double obrate, uwbrate;
	extern struct dchrstr dchr[];
	extern struct natstr *natp;
	extern struct pchrstr pchr[];
	extern struct sctstr sect;
	struct nstr nstr;
	struct pchrstr *pp;
	double  effic;
	double  maxr;			    /* floating version of
					     * max */
	double  prodeff;
	double  real;			    /* floating pt version
					     * of act */
	double  work;
	int     act;			    /* actual production */
	int     cost;
	int     i;
	int     max;			    /* production w/infinate
					     * materials */
	double  maxtake;
	int     nsect;
	int     take;
	int     mtake;
	int     there;
	int     totcomp;		    /* sum of component
					     * amounts */
	int     used;			    /* production w/infinate
					     * workforce */
	int     wforce;
	int     it;
	short  *amount;			    /* amount for component
					     * pointer */
	u_char *comp;			    /* component pointer */
	u_char *endcomp;
	u_char  vtype;
	char   *resource;
	int     c;
	char    maxc[3][10];
	char    use[3][10];

	if (snxtsct(&nstr, argp[1]) < 0)
		return RET_SYN;
	prdate();
	nsect = 0;

	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;

		totcomp = 0;
		pp = &pchr[dchr[sect.sct_type].d_prd];
		vtype = pp->p_type;

		/*
		 * workforce that will be available (inc
		 * new babies)
		 */
		wforce = min(999, (int) ((obrate * (double) PROD_ETU + 1.0)
					 * (double) gsctv(V_CIVIL)))
		    * sect.sct_work / 100.0
		    + min(999, (int) ((uwbrate * (double) PROD_ETU + 1.0)
				      * (double) gsctv(V_UW)))
		    + gsctv(V_MILIT) * 2 / 5;

		/*
		 * sect effic  (inc improvements)
		 */
		effic = (sect.sct_effic + (wforce / 100.0)) / 100.0;
		if (effic < 0.60)
			continue;
		if (effic > 1.0)
			effic = 1.0;

		if (sect.sct_type == SCT_ENLIST)
			goto is_enlist;

		if (dchr[sect.sct_type].d_prd == 0)
			continue;	    /* This type of sector
					     * produces nothing
					     * tangible. */

		if (pp->p_nrndx != 0) {
			totcomp++;
			resource = ((char *) &sect) + pp->p_nrndx;
			effic = (*resource * effic) / 100.0;
			if (pp->p_nrdep > 0) {
				maxtake = (*resource * 100.0) / pp->p_nrdep;
				if (effic > maxtake)
					effic = maxtake;
			}
		}
		/*
		 * production effic.
		 */
		if (pp->p_nlndx >= 0) {
			getnat(sect.sct_own);	/* so deity can spy */
			prodeff = natp->nat_level[pp->p_nlndx] - pp->p_nlmin;
			if (prodeff < 0.0) {
				prodeff = 0.0;
			}
			prodeff = prodeff / (prodeff + pp->p_nllag);
		} else {
			prodeff = 1.0;
		}

		used = 999;
		comp = pp->p_vtype;
		endcomp = pp->p_vtype + pp->p_nv;
		amount = pp->p_vamt;

		while (comp < endcomp) {
			used = min(used, gsctv(*comp) / *amount);
			totcomp += *amount;
			++comp;
			++amount;
		}

		if (totcomp == 0)
			continue;

		/*
		 * is production limited by resources or
		 * workforce?
		 */
		work = PROD_ETU * wforce / 100.0;
		max = (work * effic / (double) totcomp) + 0.5;
		act = min(used, max);
		/*
		 * some things are easier to make..  food,
		 * pet, etc.
		 */
		act = (pp->p_effic * 0.01 * act) + 0.5;
		max = (pp->p_effic * 0.01 * max) + 0.5;

		real = act * prodeff;
		maxr = max * prodeff;

		if (vtype != 0) {
			if (real < 0.0)
				real = 0.0;
			if ((there = gsctv(vtype)) >= 999) {
				/*
				 * production backlog
				 */
				there = 999;
			}
			act = min(act, 999 - there);
			max = min(max, 999 - there);
		}
		if (prodeff != 0) {
			take = real / prodeff;
			mtake = maxr / prodeff;
		} else
			mtake = take = 0.0;

		cost = take * pp->p_cost;

		take = take / ((double) pp->p_effic * 0.01);
		mtake = mtake / ((double) pp->p_effic * 0.01);

		comp = pp->p_vtype;
		amount = pp->p_vamt;
		i = 0;
		while (comp < endcomp) {
			it = unitem((int) *comp);
			if (it > 0 && it < maxitem && ichr[it].i_name != 0)
				c = ichr[it].i_name[0];
			else
				c = ' ';
			sprintf(use[i], " %3d%c",
				(int) (take * (double) *amount + 0.5), c);

			sprintf(maxc[i], " %3d%c",
				(int) (mtake * (double) *amount + 0.5), c);

			++comp;
			++amount;
			++i;
		}
		while (i < 3) {
			strcpy(use[i], "     ");
			strcpy(maxc[i], "     ");
			++i;
		}


is_enlist:

		if (nsect++ == 0) {
			pr("PRODUCTION SIMULATION\n");
			pr(" sect  des eff wkfc will make--- p.e. cost use1 use2 use3  max1 max2 max3   max\n");
		}
		pr(fmt("%3d,%-3d ", xwrap(sect.sct_x), ywrap(sect.sct_y)));
		pr(fmt("%c", dchr[sect.sct_type].d_mnem));
		pr(fmt(" %3.0f%%", effic * 100.0));

		pr(fmt(" %4d", wforce));
		if (vtype != 0) {
			pr(fmt(" %4d", (int) (real + 0.5)));
		} else if (sect.sct_type != SCT_ENLIST) {
			switch (pp->p_level) {
			case NAT_TLEV:
			case NAT_RLEV:
				pr(fmt(" %1.2f", real));
				break;
			case NAT_ELEV:
			case NAT_HLEV:
				pr(fmt(" %4.0f", real));
				break;
			default:
				pr(fmt("ERROR"));
				break;
			}
		} else {
			/* enlistment center.... */
			int     newc = min(999, (int) ((obrate * (double) PROD_ETU + 1.0)
						       * (double) gsctv(V_CIVIL)));
			int     mil = gsctv(V_MILIT);
			int     topmil = (mil + 10) * (1.0 + (double) PROD_ETU / 20.0);
			int     topciv = newc / 2;
			int     maxciv = newc / (2.0 + (double) PROD_ETU / 10.0) - 10;
			int     maxi = topciv - maxciv;
			int     actual = ((topmil > topciv) ?
					  topciv : topmil) - mil;
			if (actual < 0)
				actual = 0;
			pr(fmt(" %4d mil     1.0 $%-4d %3dc ",
			       actual, actual * 3, actual));
			pr(fmt("           %3dc           %4d\n",
			       actual, maxi, maxi));
			continue;
		}

		pr(fmt(" %-7s", pp->p_sname));
		pr(fmt(" %.2f", prodeff));
		pr(fmt(" $%-3d", cost));
		for (i = 0; i < 3; i++) {
			pr(use[i]);
		}
		pr(" ");
		for (i = 0; i < 3; i++) {
			pr(maxc[i]);
		}
		if (vtype != 0 || pp->p_level == NAT_ELEV
		    || pp->p_level == NAT_HLEV)
			pr(fmt(" %4d\n", (int)(max * prodeff + 0.05)));
		else
			pr(fmt(" %1.2f\n", maxr));
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return RET_OK;
}
