#ifndef lint
static char *RCSid = "$Header: powe.c 1.10 89/03/17 $";
#endif

/*
 * powe.c
 *
 * Do a power report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include <sys/file.h>
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "ship.h"
#include "nuke.h"
#include "power.h"
#include "item.h"
#include "plane.h"

static void out5();

int
powe()
{
	extern struct dchrstr dchr[];
	extern struct ichrstr ichr[];
	extern struct vchrstr vchr[];
	extern struct mchrstr mchr[];
	extern struct sctstr sect;
	extern struct shpstr ship;
	extern int powf;
	extern int sectf;
	extern double powe_cost;
	extern int btused, nbtu;
	extern char *powfil;
	extern struct natstr *natp;
	extern int maxnoc;
	extern int maxcno;
	extern int cnum;
	extern int god;
	extern int w_xsize, w_ysize;
	extern char *argp[];
	register struct powstr *pow;
	register int i;
	register int j;
	int     country;
	int     round_flag;
	long    pow_time;
	float   max_power;
	struct powstr powbuf[MAXNOC];

	pr("     - = [   Empire Power Report   ] = -\n");
	if ((powf = open(powfil, O_RDWR, 0)) == -1)
		return RET_SYS;

	if (argp[1] && argp[1][0] == 'n') {
		if (nbtu < 1)
			pr("\n  Insufficient BTUs, using the last report.\n\n");
		else {
			if ((i = gen_power(powf)) != RET_OK) {
				close(powf);
				return i;
			}
		}
	}
	if (read(powf, (char *) &pow_time, sizeof(pow_time)) != sizeof pow_time) {
		(void) close(powf);
		return RET_SYS;
	}
	if (read(powf, (char *) powbuf, sizeof(powbuf)) != sizeof powbuf) {
		(void) close(powf);
		return RET_SYS;
	}
	(void) close(powf);
	pr(fmt("      as of %s\n         sects  eff  civ", ctime(&pow_time)));
	pr("  mil shell gun  pet iron dust food oil pln  ship money\n");
	for (i = 0; i < maxcno; i++) {
		max_power = 0.;
		for (j = 1; j < maxnoc; j++) {
			pow = &powbuf[j];
			if (pow->p_power > max_power) {
				max_power = pow->p_power;
				country = j;
			}
		}
		if (max_power == 0.)
			break;
		pow = &powbuf[country];
		if (country != cnum && cnum != 0)
			round_flag = 0;
		else
			round_flag = 1;
		pr(fmt("%9.9s", cname(country)));
		out5(pow->p_sects, 5, round_flag);
		pr(fmt("%4.0f%%", pow->p_effic / (pow->p_sects + 0.1)));
		out5(pow->p_civil, 50, round_flag);
		out5(pow->p_milit, 50, round_flag);
		out5(pow->p_shell, 25, round_flag);
		out5(pow->p_guns, 5, round_flag);
		out5(pow->p_petrol, 50, round_flag);
		out5(pow->p_iron, 50, round_flag);
		out5(pow->p_dust, 50, round_flag);
		out5(pow->p_food, 50, round_flag);
		out5(pow->p_oil, 50, round_flag);
		out5(pow->p_planes, 10, round_flag);
		out5(pow->p_ships, 10, round_flag);
		out5(pow->p_money, 5000, round_flag);
		pr("\n");
		if (god != 0)
			pr(fmt("%9.2f\n", pow->p_power));
		pow->p_power = 0.;
	}
	pr("          ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ---- ----\n");
	pow = &powbuf[0];
	pr("worldwide");
	out5(pow->p_sects, 5, 0);
	pr(fmt("%4.0f%%", pow->p_effic / (pow->p_sects + 0.1)));
	out5(pow->p_civil, 50, 0);
	out5(pow->p_milit, 50, 0);
	out5(pow->p_shell, 25, 0);
	out5(pow->p_guns, 5, 0);
	out5(pow->p_petrol, 50, 0);
	out5(pow->p_iron, 50, 0);
	out5(pow->p_dust, 50, 0);
	out5(pow->p_food, 50, 0);
	out5(pow->p_oil, 50, 0);
	out5(pow->p_planes, 10, 0);
	out5(pow->p_ships, 10, 0);
	out5(pow->p_money, 5000, 0);
	pr("\n");
	return RET_OK;
}

static void
out5(value, round_val, round_flag)
	double  value;
	int     round_val;
	int     round_flag;
{
	if (value > round_val && round_flag == 0)
		value = (int) (value / round_val + 0.5) * round_val;
	if (value < -995000.)
		pr(fmt("%4.0fM", value / 1e6));
	else if (value < -9950.)
		pr(fmt("%4.0fK", value / 1000.));
	else if (value < -999.)
		pr(fmt("%4.1fK", value / 1000.));
	else if (value < 1000.)
		pr(fmt("%4.0f ", value));
	else if (value < 10000.)
		pr(fmt("%4.1fK", value / 1000.));
	else if (value < 1e6)
		pr(fmt("%4.0fK", value / 1000.));
	else if (value < 1e7)
		pr(fmt("%4.1fM", value / 1e6));
	else if (value >= 1e9)
		pr(fmt("%4.0fG", value / 1e9));
	else
		pr(fmt("%4.0fM", value / 1e6));
}

static int 
gen_power(fd)
{
	int     strip_size;
	float  *f_ptr;
	float  *f_pt2;
#ifdef notdef
	struct nukstr nuke;
	int     nuke_num;
#endif
	struct sctstr strip[MAX_W_SIZE];
	struct plnstr plane;
	register struct sctstr *sct;
	register struct powstr *pow;
	struct powstr powbuf[MAXNOC];
	register int i, j;
	time_t  pow_time;

	btused += powe_cost;
	bzero((char *) powbuf, sizeof(powbuf));
	lseek(sectf, (off_t) 0, 0);
	strip_size = w_xsize * sizeof(struct sctstr) / 2;
	for (j = 0; j < w_ysize; j++) {
		if (read(sectf, (char *) strip, strip_size) != strip_size)
			return RET_SYS;
		for (i = w_xsize / 2 - 1; i >= 0; i--) {
			if (strip[i].sct_own == 0)
				continue;
			sct = &strip[i];
			pow = &powbuf[sct->sct_own];
			pow->p_sects += 1.0;
			pow->p_effic += sct->sct_effic;
			pow->p_civil += getvar(V_CIVIL, sct, GT_SECT);
			pow->p_milit += getvar(V_MILIT, sct, GT_SECT);
			pow->p_shell += getvar(V_SHELL, sct, GT_SECT);
			pow->p_guns += getvar(V_GUN, sct, GT_SECT);
			pow->p_petrol += getvar(V_PETROL, sct, GT_SECT);
			pow->p_iron += getvar(V_IRON, sct, GT_SECT);
			pow->p_dust += getvar(V_DUST, sct, GT_SECT);
			pow->p_food += getvar(V_FOOD, sct, GT_SECT);
			pow->p_oil += getvar(V_OIL, sct, GT_SECT);
			pow->p_power += getvar(V_LCM, sct, GT_SECT) / 10.;
			pow->p_power += getvar(V_HCM, sct, GT_SECT) / 5.;
		}
	}
	for (i = 0; getship(i, &ship) != -1; i++) {
		if (ship.shp_own == 0)
			continue;
		pow = &powbuf[ship.shp_own];
		pow->p_civil += gshpv(V_CIVIL, &ship);
		pow->p_milit += gshpv(V_MILIT, &ship);
		pow->p_shell += gshpv(V_SHELL, &ship);
		pow->p_guns += gshpv(V_GUN, &ship);
		pow->p_petrol += gshpv(V_PETROL, &ship);
		pow->p_iron += gshpv(V_IRON, &ship);
		pow->p_dust += gshpv(V_DUST, &ship);
		pow->p_food += gshpv(V_FOOD, &ship);
		pow->p_oil += gshpv(V_OIL, &ship);
		pow->p_ships += 1.0;
		pow->p_power += gshpv(V_LCM, &ship) / 10.;
		pow->p_power += gshpv(V_HCM, &ship) / 5.;
		pow->p_power += mchr[ship.shp_type].m_lcm / 10.;
		pow->p_power += mchr[ship.shp_type].m_hcm / 5.;
	}
	for (i = 0; getplane(i, &plane) != -1; i++) {
		if (plane.pln_own == 0)
			continue;
		pow = &powbuf[plane.pln_own];
		pow->p_planes += 1.0;
		pow->p_power += plane.pln_effic / 10.0;
	}
#ifdef notdef
	for (nuke_num = 0; getnuke(&nuke, nuke_num) >= 0; nuke_num++) {
		if (nuke.nuk_size == 0)
			continue;
		getsect(nuke.nuk_x, nuke.nuk_y);
		pow = &powbuf[sect.sct_own];
		pow->p_power += nuke.nuk_size * 100.0;
	}
#endif
	for (i = 1; i < maxnoc; i++) {
		getnat(i);
		pow = &powbuf[i];
		if ((natp->nat_stat & (STAT_INUSE|STAT_NORM|STAT_GOD)) !=
				(STAT_INUSE|STAT_NORM)) {
			pow->p_power = 0.;
			continue;
		}
		pow->p_money = natp->nat_money;
		pow->p_power += pow->p_money / 100.;
		pow->p_power += pow->p_petrol / 50.0;
		pow->p_power += (pow->p_civil + pow->p_milit +
				 pow->p_shell) / 10.;
		pow->p_power += (pow->p_iron + pow->p_dust +
				 pow->p_effic + pow->p_oil) / 10.;
		pow->p_power += (pow->p_guns + pow->p_effic) / 3.;
		pow->p_power += pow->p_ships;
		pow->p_power += pow->p_sects * 3.0;
		pow->p_power += pow->p_planes * 5.0;
		f_pt2 = &(powbuf[0].p_sects);
		f_ptr = &(pow->p_sects);
		while (f_ptr <= &(pow->p_power)) {
			*f_pt2 += *f_ptr;
			f_pt2++;
			f_ptr++;
		}
	}
	(void) lseek(fd, (off_t) 0, 0);
	(void) time(&pow_time);
	(void) write(fd, (char *) &pow_time, sizeof(pow_time));
	(void) write(fd, (char *) powbuf, sizeof(powbuf));
	(void) lseek(fd, (off_t) 0, 0);
	return RET_OK;
}
