#ifndef lint
static char *RCSid = "$Header: path.c 1.6 89/03/17 $";
#endif

/*
 * path.c
 *
 * Show empire distribution paths.
 *
 * David Muir Sharnoff, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"

#define MP 10
#define BOUNDS MP*2+1

struct xydir {
	int     x, y;
	int     dir;
};

int
path()
{
	extern char *copy();
	extern char *masktopath();
	extern char *argp[];
	extern char *dc[7][2];		    /* In route.c */
	extern char bitmap[];		    /* In map.c */
	extern struct sctstr sect;
	extern int cnum;
	extern int sct_maxno;
	extern int sx, sy;
	extern int god;
	struct xydir pathxy[MP];
	int     i;
	int     len;
	int     lx, hx, ly, hy, cx, cy;
	register int x;
	register int y;
	char    buffer[133];
	char   *buf_ptr;
	int     own;
	int     off;
	int     type;
	char    c, *pp;

	if (getsno(argp[1], "from sector : ") < 0)
		return 2;

	pp = masktopath(sect.sct_distpath);

	hx = lx = cx = xwrap(sect.sct_x);
	hy = ly = cy = ywrap(sect.sct_y);

	for (i = 0; i < MP; i++) {
		pathxy[i].x = cx;
		pathxy[i].y = cy;
		pathxy[i].dir = dirtoval(*pp);
		switch (*pp++) {
		case 'n':
			if (++cx > hx)
				hx = cx;
			if (++cy > hy)
				hy = cy;
			break;
		case 'j':
			cx += 2;
			if (cx > hx)
				hx = cx;
			break;
		case 'u':
			if (++cx > hx)
				hx = cx;
			if (--cy < ly)
				ly = cy;
			break;
		case 'y':
			if (--cx < lx)
				lx = cx;
			if (--cy < ly)
				ly = cy;
			break;
		case 'g':
			cx -= 2;
			if (cx < lx)
				lx = cx;
			break;
		case 'b':
			if (--cx < lx)
				lx = cx;
			if (++cy > hy)
				hy = cy;
			break;
		default:
			len = i;
			i = MP;
			break;
		}
	}

	lx -= 1;
	ly -= 1;
	hx += 1;
	hy += 1;

	bitinit(lx, hx, 1, ly, hy, 1);
	border(lx, hx + 1, 1, "    ", " ");

	for (y = ly; y <= hy; y++) {
		buf_ptr = buffer;
		if (((lx ^ y) & 01) == 1)
			*buf_ptr++ = ' ';
		for (x = lx; x <= hx; x++) {
			if ((y + x) & 01) {
				*buf_ptr++ = ' ';
				continue;
			}
			if (!god && !getbit(y, x, bitmap)) {
				buf_ptr = copy("   ", buf_ptr);
				continue;
			}
			for (i = 0; i < len; i++)
				if ((pathxy[i].x == x) && (pathxy[i].y == y)) {
					buf_ptr = copy(dc[pathxy[i].dir][0],
						       buf_ptr);
					break;
				}
			if (i == len)
				buf_ptr = copy("   ", buf_ptr);
			off = sctoff(x, y);
			type = sctdes(off);
			own = sctown(off);
			if (type > sct_maxno)
				c = '?';
			else {
				c = dchr[type].d_mnem;
				switch (type) {
				case SCT_WATER:
				case SCT_RURAL:
				case SCT_MOUNT:
				case SCT_WASTE:
					break;
				default:
					if (own != cnum && !god)
						c = '?';
					break;
				}
			}
			if (i == 0)
				c = '0';
			if ((x == cx) && (y == cy))
				c = '1';
			buf_ptr[-2] = c;
		}
		if (((hx ^ y) & 1) == 1)
			*buf_ptr++ = ' ';
		*buf_ptr = 0;
		pr(fmt("%3d %s %d\n", y, buffer, y));
	}

	border(lx, hx + 1, 1, "    ", " ");
	return RET_OK;
}
