#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/offs.c,v 1.5 89/03/07 16:49:17 muir Exp $";
#endif

/*
 * offs.c
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "nat.h"

offs()
{
	extern char *getstarg();
	extern char *fmt();
	extern char *argp[];
	extern int maxcno;
	extern struct natstr *natp;
	extern int xorg, yorg;
	extern int cnum;
	extern int lx, ly;
	register int i;
	char   *cp;

	cp = getstarg(argp[1], "sector or nation? ");
	if (landorsea(cp) == LAND) {
		if (sargs(cp) < 0)
			return RET_SYN;
		xorg += lx;
		yorg += ly;
	} else if (isdigit(*cp) || *cp == '-') {
		i = atoi(cp);
		if (i < 0 || i > maxcno)
			return RET_SYN;
		xorg += capxof(i);
		yorg += capyof(i);
	} else {
		/* actually nation name */
		if ((i = natarg(cp, "")) < 0)
			return RET_SYN;
		xorg += capxof(i);
		yorg += capyof(i);
	}
	getnat(cnum);
	NAT_SET(nat_xcap, cnum, xorg);
	NAT_SET(nat_ycap, cnum, yorg);
	offset(xorg, yorg);
	pr(fmt("Absolute offset is now %d,%d\n", xorg, yorg));
	return RET_OK;
}
