#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/offe.c,v 1.4 89/03/07 16:49:15 muir Exp $";
#endif

/*
 * offe.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "loan.h"
#include "treaty.h"

#define SECS_PER_DAY 86400

extern char *getstarg();
extern char *argp[];

int
offe()
{
	register char *cp;

	cp = getstarg(argp[1], "loan or treaty? ");
	switch (*cp) {
	case 'l':
		return do_loan();

	case 't':
		return do_treaty();

	default:
		pr("You must specify \"loan\" or \"treaty\".\n");
		return RET_SYN;
	}
}

static int 
do_treaty()
{
	extern char *getstring();
	extern int cnum;
	extern struct natstr *natp;
	register char *cp;
	register int i;
	register int j;
	register int recipient;
	register int number;
	long    now;

	recipient = natarg(argp[2], "Treaty offered to ?");
	if (recipient == -1)
		return RET_SYN;
	if (recipient == cnum) {
		pr("You can't loan money to yourself!\n");
		return RET_FAIL;
	}
	number = 0;
	while (1) {
		if (gettre(number) == -1 ||
		    trty.trt_cna == 0)
			break;
		number++;
	}

	pr(fmt("Terms for %s :\n", cname(recipient)));
	for (j = i = 0; j < 8; j++) {
		cp = getstring(fmt("%s? ", tchr[j].t_name));
		if (*cp == 'y')
			i |= tchr[j].t_cond;
	}
	trty.trt_bcond = i;
	pr("Terms for you :\n");
	for (j = i = 0; j < 8; j++) {
		cp = getstring(fmt("%s? ", tchr[j].t_name));
		if (*cp == 'y')
			i |= tchr[j].t_cond;
	}
	trty.trt_acond = i;
	j = atopi(getstring("Proposed treaty duration? (days) "));
	(void) time(&now);
	trty.trt_exp = j * SECS_PER_DAY + now;
	trty.trt_cna = cnum;
	trty.trt_cnb = -recipient;
	wu(0, recipient, fmt("Treaty #%d proposed to you by %s",
			     number, cname(cnum)));
	puttre(number);
	pr(fmt("You have proposed treaty #%d\n", number));
	return RET_OK;
}

static int 
do_loan()
{
	register int recipient;
	register int i, maxloan;
	int     number;

	recipient = natarg(argp[2], "lend to ?");
	if (recipient == -1 || recipient == cnum)
		return RET_SYN;
	getnat(cnum);
	if (natp->nat_money + 100 > MAXLOAN)
		maxloan = MAXLOAN;
	else
		maxloan = natp->nat_money - 100;
	if (maxloan < 0) {
		pr("You don't have enough money to loan!\n");
		return RET_FAIL;
	}
	i = onearg(argp[3],
		   fmt("Size of loan for country #%d? (max %d) ",
		       recipient, maxloan));
	if (i == 0)
		return RET_SYN;
	if (i > maxloan) {
		pr("You can't afford that much...");
		return RET_FAIL;
	}
	number = 0;
	while (1) {
		if (getloan(number) == -1)
			break;
		if (loan.l_ldur == 0)
			break;
		number++;
	}
	loan.l_loner = loan.l_lonee = 0;
	loan.l_ldur = 1;
	putloan(number);
	loan.l_amtdue = i;
	i = onearg(argp[4], "Duration? (days, max 127) ");
	loan.l_ldur = min(i, 127);
	i = onearg(argp[5], "Interest rate? (max 127%) ");
	loan.l_irate = min(i, 127);
	loan.l_loner = cnum;
	loan.l_lonee = recipient;
	loan.l_amtpaid = -1;
	(void) time(&loan.l_lastpay);
	loan.l_duedate = loan.l_ldur * SECS_PER_DAY + loan.l_lastpay;
	putloan(number);
	pr(fmt("You have offered loan %d\n", number));
	wu(0, recipient, fmt("Country #%d has offered you a loan (#%d)",
			     cnum, number));
	return RET_OK;
}
