#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/nuke.c,v 1.6 89/05/10 01:57:54 muir Exp $";
#endif

/*
 * nuke.c
 *
 * combines fail, deto, and nuke report
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

int
nuke()
{
	extern char *argp[];
	register int first_line;
	register int i;
	struct	nstr_item nstr;
	struct	nukstr nuke;

	if (!snxtitem(&nstr, EF_NUKE, argp[1]))
		return RET_SYN;
	first_line = 0;
	while (nxtitem(&nstr, &nuke)) {
		if (!god && !owner)
			continue;
		if (nuke.nuk_own == 0)
			continue;
		if (first_line++ == 0) {
			if (god)
				pr("own");
			pr(" nuke  x, y\n");
		}
		if (god)
			pr(fmt("%-3d", nuke.nuk_own));
		pr(fmt(" %3d  %-7.7s\n", nstr.cur,
			xyas(nuke.nuk_x, nuke.nuk_y, cnum)));
		for (i = 0; i < nuk_maxno; i++) {
			if (nuke.nuk_types[i] > 0) {
				pr(fmt("         %d  %s\n", nuke.nuk_types[i],
				       nchr[i].n_name));
			}
		}
	}
	return RET_OK;
}
