static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/news.c,v 1.7 89/05/10 01:57:35 muir Exp $";

/*
 * news
 *
 * Show the current empire news
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

news()
{
	extern	char *argp[];
	struct	natstr *natp;
	long	now;
	int	page;
	int	delta;
	long	then;
	struct	nwsstr news;
	struct	nstr_item nstr;

	head();
	(void) time(&now);
	natp = getnatp(cnum);
	if (argp[1] != 0 && *argp[1] != 0) {
		then = days(atoi(argp[1]));
		delta = now - then;
	} else
		delta = natp->nat_newstim;
	NAT_SET(nat_newstim, cnum, now);
	if (delta < now - days(3))
		delta = now - days(3);
	snxtitem_all(&nstr, EF_NEWS);
	pr(fmt("\nThe details of Empire news since %s", ctime(&delta)));
	for (page = 1; page <= 3; page++) {
		pr(fmt("\n\t === page %d ===\n", page));
		while (nxtitem(&nstr, &news)) {
			if (rpt[news.nws_vrb].r_newspage != page)
				continue;
			if (news.nws_when < delta)
				continue;
			if (news.nws_ntm == 0)
				news.nws_ntm = 1;
			preport(&news);
		}
		if (page < 3)
			snxtitem_rewind(&nstr);
	}
	return 0;
}

preport(np)
	register struct nwsstr *np;
{
	register char *cp;
	register int i;
	char	buf[255];
	char	*ptr;

	cp = buf;
	*cp = 0;
	cp = copy(fmt("%-16.16s  ", ctime(&np->nws_when)), cp);
	ptr = numstr(np->nws_ntm);
	/*
	 * vary the order of the printing of "%d times "
	 */
	if ((random() & 3) == 0 && np->nws_ntm > 1) {
		cp = copy(fmt("%s times ", ptr), cp);
		np->nws_ntm = 1;
	}
	cp = copy(cname(np->nws_ano), cp);
	*cp++ = ' ';
	if (np->nws_vrb < 1 || np->nws_vrb > N_MAX_VERB)
		np->nws_vrb = 0;
	cp = copy(fmt(rpt[np->nws_vrb].r_newstory[random() % NUM_RPTS],
		cname(np->nws_vno)), cp);
	if (np->nws_ntm != 1)
		cp = copy(fmt(" %s times", ptr), cp);
	*cp = 0;
	if (*buf >= 'a' && *buf <= 'z')
		*buf += 'A' - 'a';
	if (cp - buf > 80) {
		for (i=80; --i > 60; )
			if (buf[i] == ' ') break;
		buf[i] = '\0';
		pr(fmt("%s\n\t\t  %s\n", buf, &buf[i+1]));
	} else {
		pr(fmt("%s\n", buf));
	}
	np->nws_ntm = 0;
	return;
}
