#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/map.c,v 1.10 89/05/10 01:57:18 muir Exp $";
#endif

/*
 * map.c
 *
 * empire map: probably the most-used command in empire.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "deity.h"
#include "nat.h"

map()
{
	extern	char *argp[];
	register int x;
	register int y;
	register char *ptr;
	struct	nstr_sect nstr;
	char	bitmap[WORLD_X*WORLD_Y/8];
	char	row[WORLD_X+1];
	struct	natstr *np;
	struct	range range;
	struct	sctstr sect;

	if (!snxtsct(&nstr, argp[1]))
		return RET_FAIL;
	np = getnatp(cnum);
	if (!god) {
		bzero(bitmap, sizeof(bitmap));
		bitinit(&nstr, bitmap);
	}
	/* zap any conditionals */
	nstr.ncond = 0;
	range.lx = xrel(np, nstr.range.lx);
	range.ly = yrel(np, nstr.range.ly);
	range.hx = xrel(np, nstr.range.hx);
	range.hy = yrel(np, nstr.range.hy);
	border(&range, "    ", "");
	y = range.ly;
	do {
		if (y >= WORLD_Y/2)
			y -= WORLD_Y;
		pr(fmt("%3d ", y));
		ptr = row;
		x = range.lx;
		do {
			if (x >= WORLD_X/2)
				x -= WORLD_X;
			if ((y + x) & 01) {
				*ptr++ = ' ';
				continue;
			}
			nxtsct(&nstr, &sect);
			if (!god && !getbit(nstr.x, nstr.y, bitmap)) {
				*ptr++ = ' ';
				continue;
			}
			if (sect.sct_type > SCT_MAXDEF)
				*ptr = '?';
			else {
				*ptr = dchr[sect.sct_type].d_mnem;
				switch (sect.sct_type) {
				case SCT_WATER:
				case SCT_RURAL:
				case SCT_MOUNT:
				case SCT_WASTE:
					break;
				default:
					if (sect.sct_own != cnum && !god)
						*ptr = '?';
					break;
				}
			}
			ptr++;
		} while (++x != range.hx);
		*ptr = 0;
		pr(row);
		pr(fmt(" %d\n", y));
	} while (++y != range.hy);
	border(&range, "    ", "");
	return RET_OK;
}

/*
 * if we're not god, we have to set up the bitmaps
 * correctly for the owned sectors.  If we are god,
 * forego all this (expensive) nonsense!
 */
int
bitinit(np, bitmap)
	struct	nstr_sect *np;
	int	*bitmap;
{
	extern	int *bitmaps[];
	struct	sctstr sect;
	int	eff;

	while (nxtsct(np, &sect)) {
		if (!owner)
			continue;
		eff = sect.sct_effic / 20;
		if (eff > 4)
			eff = 4;
		eff = 4;
		setbitmap(np->x, np->y, bitmap, bitmaps[eff]);
	}
	snxtsct_rewind(np);
}

/*
 *
 * the bit offsets for each bit pattern based on the efficiency of
 * the sector.
 *
 * bitmap0:  0-20%
 * bitmap1: 21-40%
 * bitmap2: 41-60%
 * bitmap3: 61-80%
 * bitmap4: 81-100%
 */

#define bitoff(x, y) x, y 

int bitmap0[] = {
	bitoff(-1,-1), bitoff(1,-1),
	bitoff(-2,0), bitoff(0,0), bitoff(2,0),
	bitoff(-1,1), bitoff(1,1),
	bitoff(9999,9999),
};

int bitmap1[] = {
	bitoff(0,-2),
	bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1), bitoff(3,-1),
	bitoff(-2,0), bitoff(0,0), bitoff(2,0),
	bitoff(-3,1), bitoff(-1,1), bitoff(1,1), bitoff(3,1),
	bitoff(0,2),
	bitoff(9999,9999),
};

int bitmap2[] = {
	bitoff(-2,-2), bitoff(0,-2), bitoff(2,-2),
	bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1), bitoff(3,-1),
	bitoff(-4,0), bitoff(-2,0), bitoff(0,0), bitoff(2,0), bitoff(4,0),
	bitoff(-3,1), bitoff(-1,1), bitoff(1,1), bitoff(3,1),
	bitoff(-2,2), bitoff(0,2), bitoff(2,2),
	bitoff(9999,9999),
};

int bitmap3[] = {
	bitoff(-1,-3), bitoff(1,-3),
	bitoff(-4,-2), bitoff(-2,-2), bitoff(0,-2), bitoff(2,-2), bitoff(4,-2),
	bitoff(-5,-1), bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1),
		bitoff(3,-1), bitoff(5,-1),
	bitoff(-4,0), bitoff(-2,0), bitoff(0,0), bitoff(2,0), bitoff(4,0),
	bitoff(-5,1), bitoff(-3,1), bitoff(-1,1), bitoff(1,1),
		bitoff(3,1), bitoff(5,1),
	bitoff(-4,2), bitoff(-2,2), bitoff(0,2), bitoff(2,2), bitoff(4,2),
	bitoff(-1,3), bitoff(1,3),
	bitoff(9999,9999),
};

int bitmap4[] = {
	bitoff(-3,-3), bitoff(-1,-3), bitoff(1,-3), bitoff(3,-3),
	bitoff(-4,-2), bitoff(-2,-2), bitoff(0,-2), bitoff(2,-2), bitoff(4,-2),
	bitoff(-5,-1), bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1),
		bitoff(3,-1), bitoff(5,-1),
	bitoff(-6,0), bitoff(-4,0), bitoff(-2,0), bitoff(0,0), bitoff(2,0),
		bitoff(4,0), bitoff(6,0),
	bitoff(-5,1), bitoff(-3,1), bitoff(-1,1), bitoff(1,1),
		bitoff(3,1), bitoff(5,1),
	bitoff(-4,2), bitoff(-2,2), bitoff(0,2), bitoff(2,2), bitoff(4,2),
	bitoff(-3,3), bitoff(-1,3), bitoff(1,3), bitoff(3, 3),
	bitoff(9999,9999),
};

int *bitmaps[5] = {
	bitmap0,
	bitmap1,
	bitmap2,
	bitmap3,
	bitmap4,
};

