static char *RCSid = "$Header: load.c,v 1.5 89/02/11 15:58:21 muir Locked $";

/*
 * $Log:	load.c,v $
 * Revision 1.5  89/02/11  15:58:21  muir
 * after mr-frog changes
 * 
 * Revision 1.4  88/12/05  14:19:14  muir
 * after rynes patch 03.
 * you could load/unload planes when you shouldn't be able to.
 * 
 * Revision 1.3  88/07/20  11:28:12  muir
 * after chuck patch 01
 * can't unload to create commodities.
 * 
 * Revision 1.2  88/07/20  11:23:46  muir
 * before chuck patch 01
 * 
 */

/*
 * load.c
 *
 * load (unload) goods from a sector onto a ship
 *
 * from PSL Empire, 1985
 *
 * hacked to allow planes/missiles to be loaded onto carriers/subs
 * by David Sharnoff 1987 
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"	
#include "item.h"
#include "nsc.h"
#include "lock.h"

#define	LOAD	1
#define	UNLOAD	-1

int
load()
{
	extern	char *fmt();
	extern	struct ichrstr *whatitem();
	extern	char *getstarg();
	extern	char *argp[];
	extern	struct mchrstr mchr[];
	extern	struct shpstr ship;
	extern	struct sctstr sect;
	extern  struct plchrstr plchr[];	/**for nuke subs**/
	struct plnstr pln;	/**for nuke subs**/
	extern	int cnum;
	extern	int owner;
	extern	int sx, sy;
	register struct ichrstr *ich;
	register struct mchrstr *mch;
	register int item;
	register int max_amt;
	register int move_amt;
	register int ship_amt;
	register int sect_amt;
	int     load_unload;
	int     ship_num,ship_no;
	int     amount;
	int     barometer;
	struct nbstr nbst;
	struct	lock *lp;
	char	*p;
	char	*i;

	if (snxtshp(&nbst, argp[1], cnum, "Ship(s) ") == -1)
		return RET_SYN;
	load_unload = **argp == 'l' ? LOAD : UNLOAD;
	p = getstarg(argp[2], "amount or plane #: ");
	if (p == 0 || *p == 0)
		return 2;
	amount = atoi(p);
	if (amount <= 0) {
	   pr("amount must be positive\n");
	   return 2;
	   }
	i = getstarg(argp[3], "what commodity ('plane' for a plane): ");
	ich = whatitem(i, "what commodity ('plane' for a plane): ");
	if (i == 0 || i[0] == '\0') return 2;

	/* "plane" is the hack for loading a plane or missile */

	if (strncmp(i,"plane",5) == 0) {
		ship_no = nbst.nb_sno; 
		getship(ship_no,&ship);
		getplane(amount,&pln);
		getsect(pln.pln_x,pln.pln_y);

		if (ship.shp_own != cnum) {
			pr("can only load/unload onto/offof your own ships!\n");
			return 2;
		}
		if (pln.pln_own != cnum) {
			pr("can only load/unload your own planes!\n");
			return 2;
		}
		if (ship.shp_x != pln.pln_x || ship.shp_y != pln.pln_y) {
			pr("the ship and plane must be in the same sector!\n");
			return 2;
		}
		if (sect.sct_own != cnum || sect.sct_type != SCT_HARBR) {
			pr("you can only load/unload in your own harbors\n");
			return 2;
		}

		if(load_unload == LOAD){
			if(pln.pln_ship > -1){
				pr(fmt("Plane #%d is already on ship #%d!\n",
					pln.pln_uid, pln.pln_ship));
				return 2;
			}
		}
		else{	/* UNLOAD */
			if(pln.pln_ship != ship.shp_uid){
				pr(fmt("Plane #%d is not on ship #%d!\n",
					pln.pln_uid, ship.shp_uid));
				return 2;
			}
		}

		ship.shp_nplane += (load_unload==UNLOAD)?-1:1;
		if (ship.shp_nplane < 0) {
			pr("you cannot unload planes from a ship w/o planes!\n");
			return 2;
		}
		if (ship.shp_nplane > 8) {
			pr ("a ship or sub can only carry eight planes or missiles!\n");
			return 2;
		}
		if (( mchr[ship.shp_type].m_flags & M_MSL) != 0) {
			if ((plchr[pln.pln_type].pl_flags&(P_M|P_L))==(P_M|P_L)) {
				pln.pln_ship = (load_unload==UNLOAD)?-1:ship.shp_uid;
				putship(ship.shp_uid,&ship);
				putplane(pln.pln_uid,&pln);
				pr(fmt("Missile #%d %s ship #%d!\n", pln.pln_uid,
					(load_unload==UNLOAD)?"unloaded from":"loaded onto",
					ship.shp_uid));
				return RET_OK;
			} else {
				pr("can only load light missiles onto ships!\n");
				return 2;
			}
		} else {
			if (( mchr[ship.shp_type].m_flags & M_FLY) != 0) {
			    if ((plchr[pln.pln_type].pl_flags &(P_M|P_L))==P_L) {
				pln.pln_ship = (load_unload==UNLOAD)?-1:ship.shp_uid;
				putplane(pln.pln_uid,&pln);
				putship(ship.shp_uid,&ship);
				pr(fmt("Plane #%d %s ship #%d!\n", pln.pln_uid,
					(load_unload==UNLOAD)?"unloaded from":"loaded onto",
					ship.shp_uid));
				return RET_OK;
			    } else {
				pr ("can only load light planes onto aircraft carriers\n");
				return 2;
			    }
			} else {
				pr ("can only load light planes and missiles onto aircraft carriers and nuke subs\n");
				return 2;
			}
		} 
	/* return 2;	/* We should never get here but just in case... */
	}

	if (ich == 0 )
		return 2;

	ship_no = nbst.nb_sno; 
	getship(ship_no,&ship);
	LCK_INIT(lp, 1);
	while (nxtshp(&nbst, &ship)) {
		LCK_RESET(lp);
		ship_num = nbst.nb_sno;
		pr(fmt("\t%s #%d at %d, %d\n", mchr[ship.shp_type].m_name,
			ship_num, ship.shp_x, ship.shp_y));
		sy = ship.shp_y;
		sx = ship.shp_x;
		savelock(sx, sy, lp);
		if (getsect(sx, sy) == -1)
			continue;
		if (owner == 0 && chkok("") != 0)
			continue;
		if (sect.sct_type != SCT_HARBR || sect.sct_effic < 2)
			continue;
		barometer = wethr(sx, sy, 0);
		if (barometer < 730) {
			pr(fmt("  Barometer @%d in %d,%d; seas too rough.\n",
			       barometer, sx, sy));
			continue;
		}
		if (dolock(lp) == 0) {
			pr(fmt("can't lock %d,%d\n", sx, sy));
			continue;
		}
		getsect(sx, sy);
		/*
		 * don't need getship now but will later
		 */
		getship(ship_num, &ship);
		mch = &mchr[ship.shp_type];
		item = ich->i_vtype;
		ship_amt = gshpv(item, &ship);
		sect_amt = gsctv(item);
		if (sect.sct_oldown != cnum && item == V_CIVIL) {
			pr(fmt("%s civilians don't want to be %s!\n",
				load_unload == UNLOAD ? "Your" : "Those",
				load_unload == UNLOAD ?
					"unloaded there" : "loaded"));
			continue;
		}
		if (load_unload == UNLOAD) {
			max_amt = min(999 - sect_amt, ship_amt);
		} else {
			max_amt = getvar(item, mch, GT_MCHR);
			max_amt = min(sect_amt, max_amt - ship_amt);
		}
		if (max_amt <= 0)
			goto next;
		move_amt = load_unload * min(amount, max_amt);
		if (move_amt == 0)
			goto next;	/* continue */
		psctv(item, sect_amt - move_amt);
		pshpv(item, ship_amt + move_amt, &ship);
		if (gsctv(V_PSTAGE) == PLG_INFECT &&
		    gshpv(V_PSTAGE, &ship) == PLG_HEALTHY)
			pshpv(V_PSTAGE, PLG_EXPOSED, &ship);
		if (gshpv(V_PSTAGE, &ship) == PLG_INFECT &&
		    gsctv(V_PSTAGE) == PLG_HEALTHY)
			psctv(V_PSTAGE, PLG_EXPOSED);
		putsect(sx, sy);
		putship(ship_num, &ship);
next:
		dounlock();
	}
	return RET_OK;
}
