static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/head.c,v 1.7 89/05/10 01:57:02 muir Exp $";

/*
 * head.c
 *
 * Create the headlines for the news
 * WARNING: this must be recompiled if you
 * change MAXNOC
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "news.h"
#include "nat.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

struct	histstr {
	int	h_past;
	int	h_recent;
};

char	*head_meanwhile();
char	*head_describe();

head()
{
	extern	char *argp[];
	register int i;
	register struct histstr *hp;
	long	now;
	int	severity;
	int	scoop;
	int	news_per;
	int	news_age;
	struct	histstr hist[MAXNOC][MAXNOC];
	struct	natstr *natp;
	struct	nwsstr news;
	int	actor;
	int	victim;
	struct	nstr_item nstr;
	int	n;

	(void) time(&now);
	natp = getnatp(cnum);
	if (argp[1] != 0 && *argp[1] != 0) {
		news_per = days(atoi(argp[1]));
		if (news_per > days(3))
			news_per = days(3);
	} else
		news_per = natp->nat_newstim;
	pr("\n        -=[  EMPIRE NEWS  ]=-\n");
	pr("::::::::::::::::::::::::::::::::::::::::::::::::::\n");
	pr("!       \"All the news that fits, we print.\"      !\n");
	pr("::::::::::::::::::::::::::::::::::::::::::::::::::\n");
	pr(fmt("       %s", ctime(&now)));
	hp = &hist[0][0];
	bzero(hist, sizeof(hist));
	snxtitem_all(&nstr, EF_NEWS);
	while (nxtitem(&nstr, &news)) {
		news_age = now - news.nws_when;
		if (news_age > news_per)
			continue;
		if (news.nws_ano == news.nws_vno)
			continue;
		if ((i = rpt[news.nws_vrb].r_good_will) == 0)
			continue;
		if (news_age > (news_per /2))
			hist[news.nws_ano][news.nws_vno].h_past += i;
		else
			hist[news.nws_ano][news.nws_vno].h_recent += i;
	}
	for (n=0; n<5; n++) {
		if ((scoop = head_findscoop(hist, &actor, &victim)) < 10)
			break;
		severity = head_printscoop(hist, actor, victim);
		hp = &hist[actor][victim];
		severity = hp->h_recent - hp->h_past;
		if (severity <= -scoop/2 || severity >= scoop/2) {
			pr(fmt("\t%s\n", head_meanwhile(severity)));
			head_printscoop(hist, victim, actor);
		}
	}
	if (n <= 1)
		pr("Relative calm prevails.\n");
	return 0;
}

static
int
head_printscoop(hist, ano, vno)
	struct	histstr hist[][MAXNOC];
	int	ano;
	int	vno;
{
	register struct histstr *hp;
	int	severity;

	hp = &hist[ano][vno];
	severity = abs(hp->h_past) > abs(hp->h_recent) ? 1 : 0;
	severity += (hp->h_past >= 0) ? 2 : 0;
	severity += (hp->h_recent >= 0) ? 4 : 0;
	pr(fmt(head_describe(severity, hp), cname(ano), cname(vno)));
	pr("\n");
	hp->h_past = 0;
	hp->h_recent = 0;
	return severity;
}

static
char *
head_meanwhile(val)
	int	val;
{
	switch (val & 03) {
	case 0:
		return "Meanwhile";
	case 1:
		return "On the other hand";
	case 2:
		return "At the same time";
	case 3:
		return "Although";
	}
}

static
char *
head_describe(hp, what)
	struct	histstr *hp;
	int	what;
{
	char	*cp;

	cp = 0;
	switch (what) {
	case 0:
		if (hp->h_recent > hp->h_past/2)
			cp = "Bad relations between %s and %s worsen!";
		else
			cp = "Carnage wrought by %s on %s continues unabated!";
		break;
	case 1:
		if (hp->h_recent < -16)
			cp = "%s agression against %s has lessened slightly";
		else
			cp = "Peace talks may occur between %s & %s";
		break;
	case 2:
		if (hp->h_recent < -16) {
			if (hp->h_past > 0)
				cp = " ! WAR !  Reversal of prior %s -- %s relations";
			else if (hp->h_recent >= -25)
				cp = "VIOLENCE ERUPTS! -- %s wages war on %s";
			else
				cp = "%s wreaks havoc on %s!";
		} else
			cp = "Breakdown in communication between %s & %s";
		break;
	case 3:
		cp = "FLASH!    %s turns on former ally, %s!";
		break;
	case 4:
		cp = "%s \"makes friends\" with %s";
		break;
	case 5:
		if (hp->h_past >= -25)
			cp = "%s seems to have forgotten earlier disagreement with %s";
		else
			cp = "Tensions ease as %s attacks on %s seem at an end";
		break;
	case 6:
		cp = "%s good deeds further growing alliance with %s";
		break;
	case 7:
		if (hp->h_recent - hp->h_past < 12)
			cp = "Honeymoon appears to be over between %s & %s";
		else
			cp = "Friendly relations between %s & %s have cooled";
		break;
	}
	return cp;
}

static
int
head_findscoop(hist, ano, vno)
	struct	histstr hist[][MAXNOC];
	int	*ano;
	int	*vno;
{
	register struct histstr *hp;
	register int i;
	register int j;
	register int k;
	int	scoop;
	int	actor;
	int	victim;

	scoop = 9;
	actor = -1;
	victim = -1;
	hp = &hist[0][0];
	for (i = 1; i < MAXNOC; i++) {
		for (j = 1; j < MAXNOC; j++) {
			hp = &hist[i][j];
			k = abs(hp->h_recent / 2);
			if (k > scoop) {
				scoop = k;
				actor = i;
				victim = j;
			}
			k = abs(hp->h_recent - hp->h_past);
			if (k > scoop) {
				scoop = k;
				actor = i;
				victim = j;
			}
		}
	}
	*ano = actor;
	*vno = victim;
	return scoop;
}
