static char *RCSid = "$Header: hard.c,v 1.4 89/02/11 15:58:16 muir Locked $";

/*
 * $Log:	hard.c,v $
 * Revision 1.4  89/02/11  15:58:16  muir
 * after mr-frog changes
 * 
 * Revision 1.3  88/04/01  04:38:17  muir
 * rcsid now at top
 * 
 */

/*
 * hard.c
 *
 * increases the silo protection of a given missile.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "ship.h"
#include "unit.h"
#include "nsc.h"

/*
 * harden <PLANE> <LEVEL>
 */
hard() {
	extern	char *getstarg();
	extern	struct plchrstr plchr[];
	extern	double dolcost;
	extern	struct sctstr sect;
	extern	char *argp[];
	extern	int cnum;
	struct	ustr unit;
	struct	nustr nu;
	struct	plchrstr *pcp;
	struct	plnstr *pp;
	int	level;
	char	*p;
	int	hcm;
	int	n;

	if (snxtunit(&nu, U_PLANE, argp[1], cnum, "missiles? ") < 0)
		return RET_SYN;
	if ((p = getstarg(argp[2], "Increase by? ")) == 0 || *p == 0)
		return RET_SYN;
	level = atoi(p);
	if (level < 0)
		return RET_SYN;
	while (nxtunit(&nu, &unit)) {
		pp = &unit.u_plane;
		if (pp->pln_own != cnum)
			continue;
		pcp = &plchr[pp->pln_type];
		if ((pcp->pl_flags & P_M) == 0) {
			pr(fmt("%s #%d isn't a missile!\n", pcp->pl_name,
				pp->pln_uid));
			continue;
		}
		if (pp->pln_ship >= 0) {
			pr(fmt("%s #%d is on a ship!\n", pcp->pl_name,
				pp->pln_uid));
			continue;
		}
		n = level;
		if (level + pp->pln_harden > 127)
			n = 127 - pp->pln_harden;
		if (n <= 0) {
			pr(fmt("%s #%d is already completely hardened!\n",
				pcp->pl_name, pp->pln_uid));
			continue;
		}
		getsect(pp->pln_x, pp->pln_y);
		if (sect.sct_own != cnum) {
			pr(fmt("%s #%d: you don't own %d,%d!\n", pcp->pl_name,
				pp->pln_uid, pp->pln_x, pp->pln_y));
			continue;
		}
		hcm = gsctv(V_HCM);
		if (hcm < n)
			n = hcm;
		if (n == 0) {
			pr(fmt("No hcm in %d,%d\n", pp->pln_x, pp->pln_y));
			continue;
		}
		pp->pln_harden += n;
		dolcost += (5.0 * n);
		putunit(nu.nu_uno, &unit);
		psctv(V_HCM, hcm - n);
	}
    return RET_OK;
}
