static char *RCSid = "$Header: fly2.c 1.10 89/03/17 $";

/*
 * fly2.c
 *
 * third part of fly module.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "news.h"
#include "ship.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "unit.h"
#include "nat.h"
#include "item.h"

precision_bomb(pl, x, y)
	struct	plist *pl;
	int	x;
	int	y;
{
	extern	char *getstring();
	extern	char *fmt();
	extern	char *effadv[];
	extern	struct sctstr sect;
	extern	struct dchrstr dchr[];
	int	nship;
	int	nplane;
	struct	shpstr *ship;
	struct	plnstr *plane;
	struct	dchrstr *dcp;
	int	planes;
	int	ships;
	int	type;
	int	bad;
	char	*p;

	bad = 0;
	type = sect.sct_type;
	dcp = &dchr[type];
	pr(fmt("Target sector is a %s constructed %s\n", 
		effadv[sect.sct_effic/26], dcp->d_name));
	/*
	 * display ships
	 */
	nship = nunit(U_SHIP);
	ship = (struct shpstr *) alloca(sizeof(*ship) * nship);
	m_readship(ship, nship);
	ships = shiplist(ship, nship, x, y, 0);
	/*
	 * and display planes
	 */
	nplane = nunit(U_PLANE);
	plane = (struct plnstr *) alloca(sizeof(*plane) * nplane);
	m_readplane(nplane, plane);
	planes = planelist(plane, nplane, x, y);
	/*
	 * perform sub-mission
	 */
retry:
	p = getstring("Bomb what? (ship, plane, efficiency, commodities)");
	if (p == 0 || *p == 0) {
		bad++;
		if (bad > 2)
			return;
		goto retry;
	}
	switch (*p) {
	case 'p':
#ifdef notdef
		if (planes == 0) {
			pr("no planes there\n");
			goto retry;
		}
		planebomb(plane, nplane, pl, x, y);
#endif
		pr("Not implemented yet!\n");
		goto retry;
	case 's':
		if (ships == 0) {
			pr("no ships there\n");
			goto retry;
		}
		shipbomb(ship, nship, pl, x, y);
		break;
	case 'c':
		if (!gsctv(V_SHELL) && !gsctv(V_GUN) && !gsctv(V_MILIT) &&
				!gsctv(V_PETROL) && !gsctv(V_OIL)) {
			pr(fmt("No bombable commodities in %d,%d\n", x, y));
			goto retry;
		}
		commbomb(x, y, pl);
		break;
	case 'e':
		if (type != SCT_FORTR && type != SCT_HARBR && type != SCT_AIRPT
				&& type != SCT_HIWAY && type != SCT_RADAR) {
			pr(fmt("You can't pinpoint bomb a %s\n", dcp->d_name));
			goto retry;
		}
		effbomb(x, y, pl);
		break;
	default:
		pr("Bad target type.\n");
		goto retry;
	}
}

effbomb(x, y, pl)
	int	x;
	int	y;
	struct	plist *pl;
{
	extern	struct sctstr sect;
	register struct plist *plp;
	float	eff;
	int	bombs;
	int	i;

	eff = 1.0;
	for (plp = pl; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		for (i=0; i<bombs; i++) {
			if (i)
				pr("-");
			if (roll(100) > plp->pcp->pl_acc) {
				eff *= 0.88;
				pr("HIT");
			} else
				pr("miss");
		}
		pr("\n");
	}
	sect.sct_effic = (sect.sct_effic * eff);
	pr(fmt("did %.2f%% damage to efficiency in %d,%d\n",
		100.0 - (eff*100), x, y));
	wu(0, sect.sct_own, fmt("bombing raid did %.2f%% damage in %s",
		100.0 - (eff*100), xytoa(x, y, sect.sct_own)));
}

int bombcomm[] = { I_SHELL, I_GUN, I_MILIT, I_PETROL, I_OIL };

commbomb(x, y, pl)
	int	x;
	int	y;
	struct	plist *pl;
{
	extern	struct ichrstr *whatitem();
	extern	struct sctstr sect;
	extern	int cnum;
	register struct plist *plp;
	extern	struct vchrstr vchr[];
	extern	struct ichrstr ichr[];
	float	eff;
	int	bombs;
	int	n;
	int	i;
	int	amt;
	int	blownup;
	struct	ichrstr *ip;
	float	coll;

	for (i=0; i<5; i++) {
		ip = &ichr[bombcomm[i]];
		n = gsctv(ip->i_vtype);
		if (n == 0)
			continue;
		pr(fmt("some %s\n", ip->i_name));
	}
retry:
	ip = whatitem(0, "commodity to bomb? ");
	if (ip == 0 || gsctv(ip->i_vtype) == 0)
		goto retry;
	for (i=0; i<5; i++) {
		if (&ichr[bombcomm[i]] == ip)
			break;
	}
	if (i == 5) {
		pr("You can't bomb that!\n");
		goto retry;
	}
	eff = 100.0;
	coll = 100.0;
	for (plp = pl; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		for (i=0; i<bombs; i++) {
			if (i)
				pr("-");
			if (roll(100) > plp->pcp->pl_acc) {
				eff *= (100 - (roll(8) + 8)) / 100.0;
				pr("BLAM");
				coll *= 0.99;
			} else {
				coll *= 0.98;
				pr("boom");
			}
		}
		pr("\n");
	}
	amt = gsctv(ip->i_vtype);
	blownup = amt - (amt * eff / 100.0);
	psctv(ip->i_vtype, amt - blownup);
	sectdamage(x, y, (int) (100.0 - coll));
	pr(fmt("did %.2f%% damage to %s level and %.2f%% damage to %d,%d\n",
		100.0 - eff, ip->i_name, 100.0 - coll, x, y));
	nreport(cnum, N_SCT_BOMB, sect.sct_own, 1);
	wu(0, sect.sct_own,
		fmt("precision bombing raid did %.2f%% damage to %s in %s",
		100.0 - eff, ip->i_name, xytoa(x, y, sect.sct_own)));
}

shipbomb(ship, nship, pl, x, y)
	struct	shpstr *ship;
	int	nship;
	struct	plist *pl;
	int	x;
	int	y;
{
	extern	char *sprintf();
	extern	struct mchrstr mchr[];
	struct	plist *plp;
	struct	shpstr *sp;
	int	bombs;
	int	onsea;
	struct	mchrstr *mcp;
	int	acc;
	int	vis;
	int	dam;
	char	*p;
	char	*q;
	int	i;
	int	n;
	char	buf[80];

	onsea = (sect.sct_type == SCT_WATER) ? 1 : 0;
	for (plp = pl; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		p = sprintf(buf, "%s (#%d), %d bombs.  Target? ",
			plp->pcp->pl_name, plp->plane.pln_uid, bombs);
		sp = 0;
		while (sp == 0) {
			q = getstring(p);
			if (q == 0 || *q == 0)
				continue;
			if (*q == '?') {
				shiplist(ship, nship, x, y, 0);
				continue;
			}
			if (*q == 'd')
				goto next;
			n = atoi(q);
			if (n < 0 || n > nship)
				continue;
			sp = &ship[n];
			if (sp->shp_x != x || sp->shp_y != y) {
				sp = (struct shpstr *)0;
				continue;
			}
		}
		mcp = &mchr[sp->shp_type];
		/*
		 * subs in port are sitting ducks, while subs
		 * at sea are impossible to spot.
		 */
		vis = mcp->m_visib;
		if (vis < 5) {
			if (onsea)
				continue;
			vis = 20;
		}
		shipflak(sp, plp);
		/*
		 * did the ship shoot it down?
		 */
		if (plp->state == P_DEL)
			continue;
		/*
		 * ships on high seas are harder to hit because they're
		 * moving around so much! (and practically impossible to
		 * hit for the poor strategic bombers)
		 */
		acc = plp->pcp->pl_acc - vis + (mcp->m_speed * onsea);
		dam = 0;
		if (roll(100) > acc) {
			i = roll(bombs) + 1;
			if (i > bombs)
				i = bombs;
			while (i--) {
				pr("BLAM");
				if (i)
					pr("-");
				dam += ((roll(10)+8) * 127) / mcp->m_armor;
			}
		} else {
			pr("splash\n");
		}
		nreport(cnum, N_SHP_BOMB, sp->shp_own, 1);
		if (dam > 100)
			dam = 100;
		shipdamage(sp, dam);
		wu(0, sp->shp_own, fmt("bombs did %d%% damage to %s #%d at %s",
			dam, mcp->m_name, n, xytoa(x, y, sp->shp_own)));
		pr("\n");
		putship(n, sp);
next:
		;
	}
}

#ifdef notdef
planebomb(plane, nplane, plp, x, y)
	struct	plnstr *plane;
	int	nplane;
	struct	plist *plp;
	int	x;
	int	y;
{
}
#endif

int
shiplist(ship, nship, x, y, carriers_only)
	struct	shpstr *ship;
	int	nship;
	int	x;
	int	y;
	int	carriers_only;
{
	extern	char *effadv[];
	register struct shpstr *sp;
	register int i;
	int	first;
	int	ships;

	first = 1;
	ships = 0;
	for (sp=ship, i=0; i<nship; sp++, i++) {
		if (sp->shp_x != x || sp->shp_y != y)
			continue;
		if (sp->shp_effic < 20 || sp->shp_own == 0)
			continue;
		if (carriers_only
		    && ((mchr[sp->shp_type].m_flags & M_FLY) == 0))
			continue;
		if (mchr[sp->shp_type].m_flags & M_SUB)
			continue;
		if (first) {
			pr("#          owner           eff        type\n");
			first = 0;
		}
		pr(fmt("(#%d) %10.10s  %12.12s  %s\n", i, cname(sp->shp_own),
			effadv[sp->shp_effic/26], mchr[sp->shp_type].m_name));
		ships++;
	}
	return ships;
}

int
planelist(plane, nplane, x, y)
	struct	plnstr *plane;
	int	nplane;
	int	x;
	int	y;
{
	extern	struct plchrstr plchr[];
	extern	char *effadv[];
	register struct plnstr *pp;
	register int i;
	int	first;
	int	planes;

	planes = 0;
	first = 1;
	for (pp=plane, i=0; i<nplane; pp++, i++) {
		if (pp->pln_x != x || pp->pln_y != y)
			continue;
#ifdef notdef
		if (pp->pln_effic < 20 || pp->pln_own == 0)
#else
		if (pp->pln_effic < 10 || pp->pln_own == 0)
#endif notdef
			continue;
		if (first) {
			pr("#  owner   eff   type\n");
			first = 0;
		}
		pr(fmt("(#%d) %10.10s  %12.12s  %s\n", i, cname(pp->pln_own),
			effadv[pp->pln_effic/26], plchr[pp->pln_type].pl_name));
		planes++;
	}
	return planes;
}

/*
 * sector x,y already loaded by a previous getsect
 */
nuclear_bomb(pl, x, y)
	struct	plist *pl;
	int	x;
	int	y;
{
	register struct plist *plp;

	/*
	 * hafta sigsave it because we don't like nukes
	 * getting duplicated
	 */
	sigsave();
	for (plp = pl; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		if (plp->pcp->pl_flags & P_C)
			continue;
		if (plp->plane.pln_nukeamt == 0)
			continue;
		/*
		 * just drop one nuke per plane
		 * For now, only single-hex missions
		 * for nuclear fire missions
		 * its kinda silly to drop one nuke per plane,
		 * but...
		 * also, air bursts are only thing available
		 * from planes (to make them effectively
		 * second strike weapons)
		 */
		plp->plane.pln_nukeamt--;
		detonate(plp->plane.pln_nuketype, x, y, 1, cnum);
	}
}
