static char *RCSid = "$Header: fly1.c 1.16 89/03/17 $";

/*
 * fly1.c
 *
 * second part of fly module.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "news.h"
#include "ship.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "unit.h"
#include "nat.h"


		/*       -7    -6    -5    -4    -3    -2    -1    0 */
float dogtable[16] = {	0.10, 0.15, 0.28, 0.45, 0.60, 0.75, 0.82, 1.00,
			1.10, 1.25, 1.60, 1.90, 2.25, 3.00, 4.15, 5.50, };

static	int vict;

encounter(plp, x, y, path, mission_flags)
	struct	plist *plp;
	int	x;
	int	y;
	char	*path;
	int	mission_flags;
{
	extern	char *fmt();
	extern	char *alloca();
	extern	int diroff[][2];
	extern	struct dchrstr dchr[];
	extern	int cnum;
	int	nplane;
	struct	plnstr *ilist;
	struct	shpstr *ships;
	struct	shpstr *sp;
	struct	plist  *p;
	int	nship;
	int	i;
	int	val;
	int	over;
	int	rel;
	int	dir;
	int	offs;
	int	nats[MAXNOC];
	int overfly[MAXNOC];

	nplane = nunit(U_PLANE);
	ilist = (struct plnstr *)alloca(nplane * sizeof(struct plnstr));
	m_readplane(nplane, ilist);
	bzero(overfly, sizeof(overfly));
	if(mission_flags & 1){
		if(mission_flags & P_S){
			pr("\nSPY Plane report\n");
			prdate();
			sathead();
		} else {
			pr("\nReconnaissance report\n");
			prdate();
		}
	}
	while (dir = *path++) {
		if ((val = dirtoval(dir)) == 0)
			break;
		x += diroff[val][0];
		y += diroff[val][1];
		offs = sctoff(x, y);
		if(mission_flags & 1){
			int	civ, mil;
			extern	int owner;

			getsect(x,y);
			if(sect.sct_type == SCT_WATER)
				continue;
			if(mission_flags & P_S){
				satdisp(&sect, (mission_flags&P_I)?10:50);
			} else {
				/* This is borrowed from lookout */
				if(owner)
					pr("Your ");
				else
					pr(fmt("%s (#%d) ", cname(sect.sct_own),
						sect.sct_own));
				pr(dchr[sect.sct_type].d_name);
				pr(fmt(" %d%% efficient ", owner ? sect.sct_effic :
					round(sect.sct_effic,25)));
				civ = gsctv(V_CIVIL);
				mil = gsctv(V_MILIT);
				if(civ)
					pr(fmt("with %s%d civ ", owner ? "" : "approx ",
						owner? civ : round(civ, 25)));
				if(mil)
					pr(fmt("with %s%d mil ", owner ? "" : "approx ",
						owner? mil : round(mil, 25)));
				pr(fmt("@ %d,%d\n", x, y));
				}
			}
		else{
			pr(fmt("flying over %s at %d,%d\n",
				dchr[sctdes(offs)].d_name, x, y));
			}
		if ((over = sctown(offs)) == 0 || over == cnum)
			continue;
		if(mission_flags & P_X){	/* Stealth */
			double	evade, tlev;
			tlev = (mission_flags >> 16);
			evade = tlev/(tlev+10.0);
			if(chance(evade))
				continue;
			}
		rel = getrel(over, cnum);
		if (rel == ALLIED)
			continue;
		overfly[over]++;
		wu(0, over, fmt("%s planes spotted over %s",
			cname(cnum), xytoa(x, y, over)));
		if (rel == HOSTILE || rel == AT_WAR)
			intercept(plp, ilist, nplane, over, x, y);
		i = 0;
		for (p = plp; p; p = p->next)
		  if (p->state != P_DEL)
		    i++;
		if (!i)
		  return;
	}
	/*
	 * this will be trivial if and when we get
	 * ship pointers in sect struct
	 */
	bzero(nats, sizeof(nats));
	nship = nunit(U_SHIP);
	ships = (struct shpstr *)alloca(nship * sizeof(struct shpstr));
	m_readship(ships, nship);
	for (i=0; i<nship; i++) {
		sp = &ships[i];
		if (sp->shp_own == 0)
			continue;
		if (sp->shp_x != x || sp->shp_y != y)
			continue;
		nats[sp->shp_own]++;
	}
	for (i=1; i<MAXNOC; i++) {
		if (cnum == i)
			continue;
		if (overfly[i] > 0)
			nreport(cnum, N_OVFLY_SECT, i, overfly[i]);
		if (nats[i] == 0)
			continue;
		wu(0, i, fmt("%s planes spotted over ships in %s",
			cname(cnum), xytoa(x, y, i)));
		rel = getrel(i, cnum);
		if (rel != HOSTILE && rel != AT_WAR)
			continue;
		pr(fmt("Flying over %d #%d ships...\n", nats[i], i));
		intercept(plp, ilist, nplane, i, x, y);
	}
}

/*
 * gotta be a better way of doing this...
 */
intercept(plp, planes, n, own, x, y)
	struct	plist *plp;
	struct	plnstr *planes;
	int	n;
	int	own;
	int	x;
	int	y;
{
	extern	struct plchrstr plchr[];
	extern	struct mchrstr mchr[];
	extern	struct sctstr sect;
	register struct plnstr *pp;
	register struct plchrstr *pcp;
	int	i;
	int	gas;
	struct	plist *ilist;
	struct	plist *ip;
	int	icount;
	struct	shpstr ship;

	/*pr(fmt("trying to intercept in %d,%d\n", x, y));*/
	vict = own;
	ilist = 0;
	icount = 0;
	for (pp = planes, i = 0; i<n; i++, pp++) {
		pcp = &plchr[pp->pln_type];
		/*
		 * don't bother launching more interceptors if we
		 * already outnumber them badly
		 */
		if (icount > n*4+4)
			break;
		if (pp->pln_own != own)
			continue;
		/*
		 * perhaps put in a "flags" for the individual plane
		 * units determining if they are on "tac" or "sac"
		 * interception duties.
		 *
		 * for now, every plane which can fly interception
		 * will be up in the air.
		 */
		if ((pcp->pl_flags & P_F) == 0) {
			continue;
		}
		if (pp->pln_mobil <= 0)
			continue;
		if (pp->pln_effic < 40)
			continue;
		if (pp->pln_range/2 < mapdist(x, y, pp->pln_x, pp->pln_y)) {
			continue;
		}
		if (pp->pln_ship >= 0) {
			if (getship(pp->pln_ship, &ship) < 0 ||
			    (mchr[ship.shp_type].m_flags & M_FLY) == 0 ||
			    ship.shp_own != pp->pln_own)
				continue;
			gas = gshpv(V_PETROL, &ship);
		} else {
			getsect(pp->pln_x, pp->pln_y);
			gas = gsctv(V_PETROL);
			if (sect.sct_effic < 60 && (pcp->pl_flags & P_V) == 0)
				continue;
		}
		if (gas < (pcp->pl_fuel/2)) {
			continue;
		}
		/* got one! */
		ip = (struct plist *) alloca(sizeof(struct plist));
		ip->next = ilist;
		ip->state = P_OK;
		ip->pcp = &plchr[pp->pln_type];
		ilist = ip;
		bcopy(pp, &ip->plane, sizeof(*pp));
		pp->pln_mobil -= 10;
		putplane(pp->pln_uid, pp);
		if (pp->pln_ship >= 0) {
			pshpv(V_PETROL, gas - pcp->pl_fuel/2, &ship);
			putship(pp->pln_ship, &ship);
		} else {
			psctv(V_PETROL, gas - pcp->pl_fuel/2);
			putsect(pp->pln_x, pp->pln_y);
		}
		icount++;
	}
	if (icount == 0)
		return;
	pr(fmt("%d %s fighter%s rising to intercept!\n", icount,
		cname(own), icount == 1 ? " is" : "s are"));
	wu(0, own, fmt("%d fighters flew intercept mission from %s",
		       icount, xytoa(ip->plane.pln_x, ip->plane.pln_y, own)));
#ifdef DEBUG_ORIGIN
{
	struct natstr *np;
	extern int xorg, yorg, offs_x, offs_y;
	np = getnat(own);
	pr(fmt("abs:   %3d,%-3d\n", x-xorg, y-yorg));
	pr(fmt("org:   %3d,%-3d\n", xorg, yorg));
	pr(fmt("offs:  %3d,%-3d\n", offs_x, offs_y));
	pr(fmt("real1: %3d,%-3d\n", orgxof(own)+offs_x, orgyof(own)+offs_y));
	pr(fmt("real2: %3d,%-3d\n", np->nat_xorg, np->nat_yorg));
	pr(fmt("rel1:  %3d,%-3d\n", orgxof(own), orgyof(own)));
	pr(fmt("rel2:  %3d,%-3d\n", np->nat_xorg-xorg, np->nat_yorg-yorg));
	pr(fmt("plane: %3d,%-3d\n", ip->plane.pln_x, ip->plane.pln_y));
	pr(fmt("E:     %3d,%-3d\n", np->nat_xorg, np->nat_yorg));
	pr(fmt("own:   %s\n", np->nat_cnam));
}
#endif
	
	air_to_air(plp, ilist);
	/*
	 * this HACK simply means that for the remainder of the mission,
	 * these planes won't be flying against the bombers because they've
	 * already intercepted once.
	 */
	for (ip = ilist; ip != 0; ip = ip->next) {
		planes[ip->plane.pln_uid].pln_own = 0;
	}
}

air_to_air(mis, in)
	struct	plist *mis;
	struct	plist *in;
{
	register struct plist *pp;
	int	n;
	int	m;
	int	interceptors;
	int	escorts;
	int	targets;
	int	iescorts;
	int	itargets;
	struct	plist **ielist;	/* attacking escort interceptors */
	struct	plist **itlist;	/* attacking target i's */
	struct	plist **elist;	/* escort screen */
	struct	plist **tlist;	/* targets */

	interceptors = 0;
	escorts = 0;
	targets = 0;
	iescorts = 0;
	itargets = 0;
	for (pp = mis; pp != 0; pp = pp->next) {
		if (pp->state == P_DEL)
			continue;
		if (pp->pcp->pl_flags & P_F)
			escorts++;
		else
			targets++;
	}
	elist = 0;
	tlist = 0;
	if (escorts)
		elist = (struct plist **)alloca(sizeof(char *) * escorts);
	if (targets)
		tlist = (struct plist **)alloca(sizeof(char *) * targets);
	m = n = 0;
	for (pp = mis; pp != 0; pp = pp->next) {
		if (pp->state == P_DEL)			/* these two lines added */
			continue;
		if (pp->pcp->pl_flags & P_F)
			elist[m++] = pp;
		else
			tlist[n++] = pp;		/* CORE DUMPED HERE */
	}
	for (pp = in; pp != 0; pp = pp->next) {
		if (pp->state == P_DEL)
			continue;
		interceptors++;
	}
	m = interceptors;
	if (escorts) {
		if (targets == 0)
			iescorts = interceptors;
		else
			iescorts = min(interceptors, escorts);
		m -= iescorts;
		ielist = (struct plist **)alloca(sizeof(char *) * iescorts);
	}
	if (targets && m > 0) {
		itargets = m;
		itlist = (struct plist **)alloca(sizeof(char *) * itargets);
	}
	m = 0;
	n = 0;
	for (pp = in; pp != 0; pp = pp->next) {
		if (pp->state == P_DEL)
			continue;
		if (iescorts && m < iescorts)
			ielist[m++] = pp;
		else if (itargets)
			itlist[n++] = pp;
		else
			pr("SHOULD NEVER GET THIS MESSAGE\n");
	}
	if (iescorts) {
		pr(fmt("%d escorts vs %d interceptors\n", escorts, iescorts));
		dowave(elist, ielist, escorts, iescorts);
	}
	if (itargets) {
		/*
		 * leftover interceptors get to shoot at bombers!
		 * interceptors that fought the escorts are "used up".
		 * (i.e. they don't fight in this wave)
		 */
		pr(fmt("%d interceptors vs %d targets\n", itargets, targets));
		dowave(itlist, tlist, itargets, targets);
	}
}

dowave(alist, blist, acount, bcount)
	struct	plist **alist;
	struct	plist **blist;
	int	acount;
	int	bcount;
{
	struct	plist *planedamage();
	register struct plist *ap;
	register struct plist *bp;
	int	edam;
	int	idam;
	int	afree;
	int	bfree;
	int	ai;
	int	bi;
	int	afire;
	int	bfire;
	int	afight;
	int	bfight;

	for (afight=0, ai=0; ai < acount; ai++)
		if (alist[ai]->pcp->pl_flags & P_F)
			afight++;
	for (bfight=0, bi=0; bi < bcount; bi++)
		if (blist[bi]->pcp->pl_flags & P_F)
			bfight++;
	afree = 0;
	bfree = 0;
	afire = 0;
	bfire = 0;
	ai = 0;
	bi = 0;
	/*
	 * go through both lists and find eligible planes
	 * to engage in dogfighting
	 */
	while (afire < afight || bfire < bfight) {
nexta:
		while (ai < acount && (ap = alist[ai]) == 0) {
			afree++;
			ai++;
		}
		if (afree == acount)
			break;
		if (ai >= acount) {
			afree = 0;
			ai = 0;
			goto nexta;
		}
nextb:
		while (bi < bcount && (bp = blist[bi]) == 0) {
			bfree++;
			bi++;
		}
		if (bfree == bcount)
			break;
		if (bi >= bcount) {
			bi = 0;
			bfree = 0;
			goto nextb;
		}
		pr(fmt("%s vs %s\n", ap->pcp->pl_name, bp->pcp->pl_name));
		if (ap->plane.pln_att) {
			edam = dog(ap, bp);
			if (ap->pcp->pl_flags & P_F)
				afire++;
		} else edam = 0;
		if (bp->plane.pln_att) {
			idam = dog(bp, ap);
			if (bp->pcp->pl_flags & P_F)
				bfire++;
		} else idam = 0;
		if (edam > 0)
			blist[bi++] = planedamage(bp, ap->plane.pln_own, edam);
		if (idam > 0)
			alist[ai++] = planedamage(ap, bp->plane.pln_own, idam);
	}
}

/*
 * zap plane associated with plp.
 * Damaging country is "from", damage is "dam".
 */
struct plist *
planedamage(plp, from, dam)
	struct	plist *plp;
	int	from;
	int	dam;
{
	register struct plnstr *pp;
	int	disp;
	char	*dmess;
	int	eff;

	disp = 0;
	pp = &plp->plane;
	eff = pp->pln_effic;
	if (dam <= 0)
		return plp;
	pr(fmt("  %s (#%d) takes %d", plp->pcp->pl_name, pp->pln_uid, dam));
	dmess = "";
	if (plp->pcp->pl_flags & P_M) {
		dmess = " -- impacted";
		dam = 100;
	}
	eff -= dam;
	if (eff < 0)
		eff = 0;
	if (eff < 10) {
		dmess = " -- shot down";
		disp = 1;
	} else if (chance((dam*4)/100.0)) {
		dmess = " -- aborted";
		disp = 2;
	}
	if (pp->pln_own != cnum) {
		/* tell the defender about damages */
		wu(0, pp->pln_own, fmt("%d%% %s (#%d) takes %d%s.",
			pp->pln_effic, plp->pcp->pl_name, pp->pln_uid,
			dam, dmess));
	}
	pr(fmt("%s.\n", dmess));
	pp->pln_effic = eff;
	if (disp == 1) {
		if (from != 0)
			nreport(from, N_DOWN_PLANE, pp->pln_own, 1);
		pp->pln_own = 0;
		putplane(pp->pln_uid, pp);
		plp->state = P_DEL;
		return 0;
	}
	if (disp == 2) {
		putplane(pp->pln_uid, pp);
		plp->state = P_DEL;
		return 0;
	}
	putplane(pp->pln_uid, pp);
	return plp;
}

/*
 * "dogfight"
 */
int
dog(ap, dp)
	register struct plist *ap;
	register struct plist *dp;
{
	int	n;
	float	mult;
	int	diff;

	diff = ((ap->plane.pln_att * ap->plane.pln_effic) -
		(dp->plane.pln_def * dp->plane.pln_effic)) / 100.0;
	/*
	 * non-bombers get penalized by one point in air-to-air combat.
	 */
	if (ap->pcp->pl_flags & P_F)
		diff++;
	if (dp->pcp->pl_flags & P_F)
		diff--;
	if (diff > 8)
		mult = 10.0;
	else if (diff < -7)
		mult = 0.0;
	else {
		diff += 7;
		mult = dogtable[diff];
	}
	n = roll(33) * mult;
	if (n > 100)
		n = 100;
	/* XXX DEBUG */
	wu(0, vict, fmt("  %s %d%% %s #%d --> %s %d%% %s #%d: dam %d",
		cname(ap->plane.pln_own), ap->plane.pln_effic,
		ap->pcp->pl_name, ap->plane.pln_uid,
		cname(dp->plane.pln_own), dp->plane.pln_effic,
		dp->pcp->pl_name, dp->plane.pln_uid, n));
	return n;
}

fireflak(plist, from, guns)
	struct	plist *plist;
	int	from;
	int	guns;
{
	register struct plnstr *pp;
	struct	plist *plp;
	int	n;
	float	mult;
	int	diff;

	pr(fmt("firing %d flak guns...\n", guns));
	for (plp = plist; plp != 0; plp = plp->next) {
		/*
		 * fighters don't get shot at by flak
		 * non-tactical bombers are harder to hit with flak.
		 */
		if (plp->pcp->pl_flags & P_F)
			continue;
		pp = &plp->plane;
		diff = guns - pp->pln_def;
		if ((plp->pcp->pl_flags & P_T) == 0)
			diff--;
		if (diff > 8)
			mult = 10.0;
		else if (diff < -7)
			mult = 0.01;
		else {
			diff += 7;
			mult = dogtable[diff];
		}
		n = (roll(10) + 4) * mult;
		if (n > 100)
		  n = 100;
		planedamage(plp, from, (int)(n * pp->pln_effic / 100.0));
	}
}

shipflak(sp, plp)
	struct	shpstr *sp;
	struct	plist *plp;
{
	extern	double reltech();
	extern	double techfact();
	extern	struct mchrstr mchr[];
	register struct plnstr *pp;
	struct	mchrstr *mcp;
	int	n;
	int	gun;
	int	shell;
	float	mult;
	int	diff;

	mcp = &mchr[sp->shp_type];
	gun = min(gshpv(V_GUN, sp), mcp->m_glim);
	shell = gshpv(V_SHELL, sp);
	if (gun == 0 || shell == 0)
		return;
	gun = 4.0 * techfact(sp->shp_tech, (double) gun);
	if (gun <= 0)
		return;
	pshpv(V_SHELL, shell - 1, sp);
	pr(fmt("%s firing %d flak guns...\n", mcp->m_name, gun));
	pp = &plp->plane;
	diff = gun - pp->pln_def;
	/*
	 * strategic bombers are harder to hit with flak.
	 */
	if ((plp->pcp->pl_flags & P_T) == 0)
		diff -= 2;
	if (diff > 8)
		mult = 10.0;
	else if (diff < -7)
		mult = 0.0;
	else {
		diff += 7;
		mult = dogtable[diff];
	}
	n = (roll(10) + 4) * mult;
#ifdef	notdef
	if (n > 0) {
		if (n > 100)
			n = 100;
		pp->pln_effic = ((100 - n) * pp->pln_effic) / 100.0;
	}
	pr(fmt("#%d (%s) hit for %d (%d%% chance of abort).\n",
		plp->plane.pln_uid, plp->pcp->pl_name, n, n*3));
	putplane(plp->plane.pln_uid, pp);
	if (chance((n*3)/100.0)) {
		pr(fmt("#%d (%s) aborted.\n", plp->plane.pln_uid,
			plp->pcp->pl_name));
		plp->state = P_DEL;
	}
#else
	if (n > 100)
	  n = 100;
	planedamage(plp, sp->shp_own, (int)(n * pp->pln_effic / 100.0));
#endif
}

roll(n)
	int	n;
{
	return (rand() >> 16) % n;
}

/*
 * sector x,y already loaded by a previous getsect
 */
strategic_bomb(pl, x, y)
	struct	plist *pl;
	int	x;
	int	y;
{
	extern	struct sctstr sect;
	register struct plist *plp;
	float	eff;
	float	damage;
	int	dam;
	int	bombs;
	int	n;
	int	i;

	eff = 100.0;
	for (plp = pl; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		if (plp->pcp->pl_flags & P_C)
			continue;
		else if (plp->pcp->pl_flags & P_T)
			bombs = 1;
		else
			bombs = plp->bombs;
		/*
		 * tac bombers just don't carry the bomb load.
		 */
		for (i=0; i<bombs; i++) {
			if (i)
				pr("-");
			n = roll(100);
			if (n <= 10) {
				damage = 0.92;	/* 8% */
				pr("BLAM");
			} else if (n < plp->pcp->pl_acc - 30) {
				damage = 0.95;	/* 5% */
				pr("Blam");
			} else {
				damage = 0.98;	/* 2% */
				pr("blam");
			}
			eff *= damage;
		}
		pr("\n");
	}
	dam = 100.0 - eff;
	sectdamage(x, y, dam);
	pr(fmt("did %d%% damage in %d,%d\n", dam, x, y));
	wu(0, sect.sct_own, fmt("%s bombing raid did %d%% damage in %s",
		cname(cnum), dam, xytoa(x, y, sect.sct_own)));
}

air_assault(pl, x, y)
	struct	plist *pl;
	int	x;
	int	y;
{
	extern	int btused;
	register struct plist *plp;
	int	a_mil;
	int	a_cas;
	double	a_str;
	int	d_mil;
	int	d_cas;
	double	d_str;
	int	success;
	double	odds;

	d_mil = gsctv(V_MILIT);
	a_mil = 0;
	a_cas = 0;
	d_cas = 0;
	a_str = d_str = 0;
	success = 0;
	for (plp = pl; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		if (plp->pcp->pl_flags & (P_V|P_C)) {
			a_mil += plp->misc;
			a_str += plp->misc * plp->plane.pln_effic / 100.0;
		}
	}
	switch (sect.sct_type) {
	case SCT_MOUNT:
	case SCT_WATER:
	case SCT_CAPIT:
	case SCT_FORTR:
	case SCT_WASTE:
		a_cas = a_mil;
		goto fail;
	default:
		d_str = ((dchr[sect.sct_type].d_dstr / 2.0 - 1.0) *
		  (sect.sct_effic / 100.0) + 1.0) * d_mil;
		break;
	}
	pr(fmt("attacking with %d mil, against %d\n",a_mil,d_mil));
#ifdef	notdef
	odds = ((double) a_mil / (a_mil + d_mil));
#else
	if (a_str <= 0.0)
	  odds = 0.0;
	else
	  odds = a_str / (d_str + a_str);
#endif
	pr(fmt("Your odds are %.2f%%\n", 100*odds));
	if (d_mil==0 && a_mil>0) 
		success++; 
	while (a_mil > 0 && d_mil > 0) {
		if (chance(odds)) {
			pr("!");
			d_cas++;
			d_mil--;
			if (d_mil <= 0)
				success++;
		} else {
			pr("@");
			a_mil--;
			a_cas++;
		}
	}
fail:
	wu(0, sect.sct_own,
		fmt("Country #%d lost %d air-assaulting %ssector %s",
		cnum, a_cas, success ? "(and taking) " : "",
		xytoa(x, y, sect.sct_own)));
	if (success) {
		pr(fmt("You have taken sector %d,%d\n", x, y));
		nreport(cnum, N_WON_SECT, sect.sct_own, 1);
		if (sect.sct_type == SCT_CAPIT)
			caploss(x, y, sect.sct_own,
				"which is also %s's capital!\n");
		a_mil = takeover(&sect, a_mil);
		sect.sct_mobil = 0;
		psctv(V_MILIT, a_mil);
	} else {
		pr("You have been defeated!\n");
		nreport(cnum, N_SCT_LOSE, sect.sct_own, 1);
		psctv(V_MILIT, d_mil);
	}
	pr(fmt("Casualties :\nYours... %d\n", a_cas));
	pr(fmt("Theirs.. %d\n", d_cas));
	btused += (a_cas + d_cas) * 0.15 + 0.5;
	return 0;
}
