static char *RCSid = "$Header: fly.c 1.13 89/03/17 $";

/*
 * fly.c
 *
 * uses plane units rather than plane "commodities"
 *
 * Dave Pare, 1986
 */

#ifdef hpux
#define index strchr
#include <memory.h>
#endif

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "unit.h"
#include "nsc.h"
#include "news.h"

/*
 * fly <PLANES> mission-type <SECT|path>
 *
 * mission types:
 *  strategic bombing (smashing all sector goodies)
 *  transport
 *  airborne assault
 *  pinpoint bombing (killing mil, fort eff, guns/shells, other planes,
 *	ships, tanks)
 *  recon
 *  nuclear
 *  drop-off
 */
fly() {
	extern	char *getstarg();
	extern	char *alloca();
	extern	char *index();
	extern	char *getpath();
	extern	char *strcpy();
	extern	float pathtoxy();
	extern	struct ichrstr *whatitem();
	extern	double sqrt();
	extern	double tfact();
	extern	char *fmt();
	extern	float fcost();
	extern	char *argp[];
	extern	struct plchrstr plchr[];
	extern	int lx, ly;
	extern	struct sctstr sect;
	extern	struct mchrstr mchr[];
	extern	struct ichrstr ichr[];
	extern	struct dchrstr dchr[];
	extern	int cnum;
	extern	int owner;
	int	i;
	struct	nustr nu;
	struct	ustr unit;
	char	*p;
	int	range;
	struct	plnstr *pp;
	struct	plist *plist;
	struct	plist *plp;
	char	mission;
	int	mission_flags;
	int	tx, ty;
	int	ax, ay;
	int	ap_to_target;
	struct	ichrstr *ip;
	struct	plchrstr *pcp;
	int	amt;
	int	onlyvtol;
	char	flightpath[256];
	int	n;
	int	gun;
	int	own;
	struct	shpstr ship;
	struct	shpstr *allships;
	int	nship, nshipl;
	int	cno;
	int	tech;

	plist = 0;
	if (snxtunit(&nu, U_PLANE, argp[1], cnum, "planes? ") < 0)
		return 2;
	p = getstarg(argp[2], "mission type? ");
	if (p == 0 || *p == 0)
		return 2;
	mission = *p;
	if (index("psatrnd", mission) == 0) {
		pr("What kind of a mission is that?\n");
		return 2;
	}
	/*
	 * NOTE: assembly point stuff here has a potential
	 * semantic problem if assembly point is deep in enemy
	 * territory (avoiding enemy fighters).
	 */
	p = getstarg(argp[3], "assembly point? ");
	if (sargs(p) < 0 || getsect(lx, ly) < 0)
		return 2;
	if (sect.sct_own && sect.sct_own != cnum) {
		pr("Assembly point not owned by you!\n");
		return 2;
	}
	ax = lx;
	ay = ly;
	p = getpath(argp[4], ax, ay, 0, 0, 0);
	if (p == 0 || *p == 0)
		return 2;
	(void)strcpy(flightpath, p);
	tx = ax;
	ty = ay;
	n = pathtoxy(flightpath, &tx, &ty, fcost);
	pr(fmt("target is %d,%d\n", tx, ty));
	getsect(tx, ty);
	own = sect.sct_own;
	onlyvtol = 0;
	cno = -1;
	if (mission == 't' || mission == 'r') {
		if (sect.sct_type != SCT_AIRPT)
			onlyvtol++;
		if (sect.sct_type == SCT_WATER
		    || sect.sct_type == SCT_HARBR) {
			nship = nunit(U_SHIP);
			allships = (struct shpstr *) alloca(sizeof(*allships)
			    * nship);
			m_readship(allships, nship);
			nshipl = shiplist(allships, nunit(U_SHIP), tx, ty, 1);
askagain:
			if (nshipl) {
				cno = getshno(argp[6], "Carrier #? ", &ship);
				/*
				 * XXX
				 * Should check here to see if the user
				 * hit a <CR> - if so, then land him in 
				 * the sector, not on the carrier.
				 */
			}
			if (cno >= 0) {
				if (ship.shp_own != cnum) {
					pr(fmt("Ship #%d is not yours.\n",
					    cno));
					goto askagain;
				}
				if (ship.shp_x != tx || ship.shp_y != ty) {
					pr(fmt("Ship #%d not in that sector!\n",
					    cno));
				}
				if ((mchr[ship.shp_type].m_flags & M_FLY) == 0){
					pr(fmt("Can't land on #%d.\n", cno));
					goto askagain;
				}
				onlyvtol = 0;
			}
		}
		if (cno == -1) {
			if (sect.sct_own != cnum) {
				pr(fmt("You don't own %d,%d!\n", tx, ty));
				return 1;
			}
		}
		if(mission == 't')
			ip = whatitem(argp[5], "Transport what? ");
		else
			ip = 0;
	} else if (mission == 'a') {
		if (sect.sct_own == cnum) {
			pr(fmt("You already own %d,%d\n", tx, ty));
			return 2;
		}
		ip = &ichr[I_MILIT];
	} else if (mission == 'd') {
		if (sect.sct_own != cnum) {
			pr(fmt("You don't own %d, %d!\n", tx,ty));
			return 1;
		}
		ip = whatitem(argp[5], "Drop off what? ");
	} else
		ip = 0;
	pp = &unit.u_plane;
	ap_to_target = strlen(flightpath);
	pr(fmt("range to target is %d\n", ap_to_target));
	/*
	 * select planes within range
	 */
	while (nxtunit(&nu, &unit)) {
		if (pp->pln_mobil <= 0)
			continue;
		range = mapdist(pp->pln_x, pp->pln_y, ax, ay);
		if (range > 4) {
			pr(fmt("%d too far from assembly point\n", nu.nu_uno));
			continue;
		}
		range += ap_to_target;
		pcp = &plchr[pp->pln_type];
		if (pcp->pl_flags & P_M || pcp->pl_flags & P_O)
			continue;
		if (mission != 't' && mission != 'r')
			range *= 2;
		if (pp->pln_range < range) {
			pr(fmt("%d out of range (%d:%d)\n", nu.nu_uno,
				pp->pln_range, range));
			continue;
		}
		if (cno >= 0) {
			/*
			 * only light planes can land on a carrier
			 */
			if ((pcp->pl_flags & P_L) == 0)
				continue;
		}
		if (pp->pln_ship >= 0) {
			if (getship(pp->pln_ship, &ship) < 0) {
	shipsunk:
				pp->pln_effic = 0;
				pr(fmt("(note) ship not valid for #%d\n",
					nu.nu_uno));
				putplane(nu.nu_uno, pp);
				continue;
			}
			if ((mchr[ship.shp_type].m_flags & M_FLY) == 0)
				goto shipsunk;
			if (ship.shp_effic < 20)
				goto shipsunk;
			if (ship.shp_effic < 50)
				continue;
		}
		/*
		 * if not vtol and not at an airport, you lose!
		 */
		if ((pcp->pl_flags & P_V) == 0 && pp->pln_ship < 0) {
			if (sctdes(sctoff(pp->pln_x, pp->pln_y)) != SCT_AIRPT) {
				pr(fmt("%d not at airport\n", nu.nu_uno));
				continue;
			}
			getsect(pp->pln_x, pp->pln_y);
			if (sect.sct_effic < 20)
				continue;
		}
		/*
		 * transport mission to non-airport sector.
		 * (talk about special case!)
		 */
		if (onlyvtol && (pcp->pl_flags & P_V) == 0)
			continue;
		pr(fmt("(#%d) %s standing by\n", nu.nu_uno,
			plchr[pp->pln_type].pl_name));
		plp = (struct plist *) alloca(sizeof(struct plist));
		plp->next = plist;
		plp->state = P_OK;
		plp->misc = 0;
		plp->bombs = 0;
		plp->pcp = pcp;
		plist = plp;
#ifdef hpux
		memcpy(&plp->plane, pp, sizeof(struct plnstr));
#else
		bcopy(pp, &plp->plane, sizeof(struct plnstr));
#endif
	}
	if (plist == 0) {
		pr("No planes have the range for that target.\n");
		return 0;
	}
	/*
	 * now arm and equip the bombers, transports, whatever.
	 */
	n = 0;
	tech = 999999;
	mission_flags = P_X;		/* stealth (maybe) */
	if (mission == 'r') ++mission_flags;
	for (plp = plist; plp != 0; plp = plp->next) {
		if (equip(plp, ip, mission) < 0) {
			plp->state = P_DEL;	/* easier than deleting it */
			continue;
		}
		if(mission == 'r'){
			if(plp->pcp->pl_flags & P_S)
				mission_flags |= P_S;
			if(plp->pcp->pl_flags & P_I)
				mission_flags |= P_I;
			}
		if (plp->pcp->pl_flags & P_X){
			i = plp->plane.pln_tech;
			if(tech > i)  tech = i;
			}
		else
			mission_flags &= ~P_X;	/* no stealth on this mission */
		if (plp->pcp->pl_flags & P_F)
			plp->plane.pln_mobil -= 12;
		else
			plp->plane.pln_mobil -= 20;
		pr(fmt("(#%d) %s equipped\n", plp->plane.pln_uid,
			plp->pcp->pl_name));
		n++;
	}
	if (n == 0) {
		pr("No planes could be equipped for the mission.\n");
		return 2;
	}
	mission_flags |= (tech << 16);
	encounter(plist, ax, ay, flightpath, mission_flags);
	n = 0;
	for (plp = plist; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		n++;
	}
	getsect(tx, ty);
	if (mission == 's' || mission == 'p' || mission == 'n')
		nreport(cnum, N_SCT_BOMB, sect.sct_own, 1);
	if (n == 0) {
		pr(fmt("No planes got through fighter defenses\n"));
	} else if (mission == 't' || mission == 'r' || mission == 'd') {
		amt = 0;
		/*
		 * deposit goodies at the end of the line
		 */
		if (cno >= 0)
			getship(cno, &ship);
		for (i=0, plp = plist; plp != 0; plp = plp->next) {
			if (plp->state == P_DEL)
				continue;
			if (ip != 0)
				amt += plp->misc;
			if (mission != 'd') {
				plp->plane.pln_x = tx;
				plp->plane.pln_y = ty;
				plp->plane.pln_ship = cno;
			}
			i++;
		}
		if (ip != 0) {
			if (cno >= 0) {
				pshpv(ip->i_vtype, gshpv(ip->i_vtype, &ship)+amt,&ship);
			} else {
				psctv(ip->i_vtype, gsctv(ip->i_vtype) + amt);
				putsect(tx, ty);
			}
		}
		if (cno < 0) {
			if (mission == 'd')
				pr(fmt("%d dropped goods in %d,%d\n",
							i, tx, ty));
			else
				pr(fmt("%d landed in %d,%d\n", i, tx, ty));
		} else {
			pr(fmt("%d landed on carrier #%d\n", i, cno));
			ship.shp_nplane += i;
			putship(cno, &ship);
		}
	} else if (mission == 'p' || mission == 's' || mission == 'a' ||
	    mission == 'n') {
		int	shell;

		shell = gsctv(V_SHELL);
		gun = gsctv(V_GUN);
		if (gun > shell*2)
			gun = shell*2;
		if (gun > 14)
			gun = 14;
		psctv(V_SHELL, shell - gun/2);
		gun = 2.0 * tfact(own, (double) gun);
		if (gun > 0)
			fireflak(plist, sect.sct_own, gun);
		putsect(tx, ty);
		switch (mission) {
		case 'p':
			precision_bomb(plist, tx, ty);
			putsect(tx, ty);
			break;
		case 's':
			strategic_bomb(plist, tx, ty);
			putsect(tx, ty);
			break;
		case 'n':
			nuclear_bomb(plist, tx, ty);
			break;
		case 'a':
			air_assault(plist, tx, ty);
			putsect(tx, ty);
			break;
		}
	}
	for (plp = plist; plp != 0; plp = plp->next) {
		if (plp->state == P_DEL)
			continue;
		putplane(plp->plane.pln_uid, &plp->plane);
	}
	return 0;
}

int
equip(plp, ip, mission)
	struct	plist *plp;
	struct	ichrstr *ip;
	char	mission;
{
	register struct plchrstr *pcp;
	int	shell;
	struct	plnstr *pp;
	int	gas;
	int	amt;
	int	there;
	int	needed;
	int	carry;
	struct	shpstr ship;
	int	onship;

	pp = &plp->plane;
	pcp = plp->pcp;
	if (pp->pln_ship >= 0) {
		getship(pp->pln_ship, &ship);
		owner = ship.shp_own == cnum;
		gas = gshpv(V_PETROL, &ship);
		shell = gshpv(V_SHELL, &ship);
		onship = 1;
	} else {
		getsect(pp->pln_x, pp->pln_y);
		gas = gsctv(V_PETROL);
		shell = gsctv(V_SHELL);
		onship = 0;
	}
	if (!owner) {
		pr(fmt("(#%d) %s is not on anything owned by you!\n",
			pp->pln_uid, plp->pcp->pl_name));
		return -1;
	}
	if (pcp->pl_fuel > gas) {
		pr(fmt("(#%d) %s not enough petrol there!\n",
			pp->pln_uid, plp->pcp->pl_name));
		return -1;
	}
	if (mission == 's' || mission == 'p') {
		needed = pcp->pl_load - 1;
		if (needed > 1 && pcp->pl_flags & P_T)
			needed = 1;
		/*
		 * if fighter plane, don't need to bail if no shells
		 */
		if (shell < needed) {
			if ((pcp->pl_flags & P_F) == 0) {
				pr(fmt("(#%d) %s not enough shells!\n",
					pp->pln_uid, plp->pcp->pl_name));
				return -1;
			}
		} else {
			plp->bombs = pcp->pl_load;
			if (onship)
				pshpv(V_SHELL, shell - needed, &ship);
			else
				psctv(V_SHELL, shell - needed);
		}
	} else if ((mission == 't' || mission == 'd') && ip != 0) {
		/*
		 * snag goodies for transport mission
		 */
		if (pcp->pl_flags & P_C) {
			there = gsctv(ip->i_vtype);
			carry = (pcp->pl_load * 2) / ip->i_lbs;
			if ((amt = min(there, carry)) <= 0) {
				pr(fmt("not enough type %d stuff\n",
				    ip->i_vtype));
				return -1;
			}
			if (ip->i_vtype == V_PETROL) {
				/* transporting petrol... -- lrj */
				gas -= amt;
				if (gas < pcp->pl_fuel) {
					if ((amt -= (pcp->pl_fuel - gas)) <= 0)
						return -1;
					gas = pcp->pl_fuel;
				}
			}
			if (onship)
				pshpv(ip->i_vtype, there - amt, &ship);
			else
				psctv(ip->i_vtype, there - amt);
			plp->misc = amt;
		}
	} else if (mission == 'a') {
		if (pcp->pl_flags & (P_V|P_C)) {
			ip = &ichr[I_MILIT];
			if (onship)
				there = gshpv(V_MILIT, &ship);
			else
				there = gsctv(V_MILIT);
			carry = pcp->pl_load / ip->i_lbs;
			if ((amt = min(there, carry)) <= 0) {
				pr(fmt("(#%d) %s not enough military there!\n",
					pp->pln_uid, plp->pcp->pl_name));
				return -1;
			}
			if (onship)
				pshpv(V_MILIT, there - amt, &ship);
			else
				psctv(V_MILIT, there - amt);
			plp->misc = amt;
		}
	} else if (mission == 'n') {
		/*
		 * only have to worry about if plane is armed
		 * with nukes
		 */
		if (pp->pln_nukeamt == 0)
			return -1;
	}
	if (onship) {
		/* subtract a plane from the ship and do a sanity check */
		ship.shp_nplane -= 1;
		if (ship.shp_nplane < 0)
			ship.shp_nplane = 0;
		pshpv(V_PETROL, gas - pcp->pl_fuel, &ship);
		putship(pp->pln_ship, &ship);
	} else {
		psctv(V_PETROL, gas - pcp->pl_fuel);
		putsect(pp->pln_x, pp->pln_y);
	}
	return 0;
}
