static char *RCSid = "$Header: fina.c 1.5 89/03/17 $";

/*
 * fina.c
 *
 * Financial report on current status of loans to countries.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "loan.h"

/*
 * format: fina
 *
 */
fina() {
	extern	char *fmt();
	extern	char *argp[];
	extern	char *strcpy();
	extern	struct lonstr loan;
	register struct lonstr *lp;
	register int i;
	char	loaner[20];
	char	loanee[20];
	long	now;
	int	rdur;
	int	xdur;
	double	rate;
	double	amt;
	int	due;
	int	last;

	(void) time(&now);
	pr("\n");
	pr("             -= Empire Financial Status Report =- \n");
	pr("                  ");
	prdate();
	pr(fmt("Loan      From            To      Rate   Dur    Paid    Total\n"));
	lp = &loan;
	for (i = 0; getloan(i) >= 0; i++) {
		if (lp->l_loner == 0 && lp->l_lonee == 0)
			continue;
		if (lp->l_amtpaid < 0 || lp->l_ldur <= 0)
			continue;
		(void) strcpy(loaner, cname(lp->l_loner));
		(void) strcpy(loanee, cname(lp->l_lonee));
		loaner[8] = 0;
		loanee[8] = 0;
		due = lp->l_duedate;
		last = lp->l_lastpay;
		rdur = 0;
		xdur = 0;
		if (now < due) {
			rdur = now - last;
			xdur = 0;
		}
		if (last < due && due < now) {
			rdur = due - last;
			xdur = now - due;
		}
		if (due < last) {
			rdur = 0;
			xdur = now - last;
		}
		rate = lp->l_irate / (lp->l_ldur * 8640000.0);
		amt = (rdur * rate + xdur * rate * 2.0 + 1.0) * lp->l_amtdue;
		pr(fmt(" %-2d  (%2d) %-8s  (%2d) %-8s ", i, lp->l_loner,
			loaner, lp->l_lonee, loanee));
		pr(fmt("%3d%%   %3d    %5d  %5d",
			loan.l_irate, lp->l_ldur, lp->l_amtpaid,
			(int) amt));
		if (now > lp->l_duedate)
			pr(" (in arrears)\n");
		else
			pr("\n");
	}
	pr("\n");
}
