#ifndef lint
static char *RCSid = "$Header: dump.c 1.6 89/03/17 $";
#endif

/*
 * dump.c
 *
 * dump sector information (census, commodity, cutoff and level)
 *
 * Jeff Wallace (jeffw@scam.Berkeley.EDU) 02-23-89
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"


dump()
{
	extern	char *fmt();
	extern	char *argp[];
	extern	char dirch[];
	extern	int owner;
	extern	int god;
	extern	struct natstr *natp;
	extern	struct dchrstr dchr[];
	extern	struct sctstr sect;
	char	*dirstr;
	int	nsect;
	int	n;
	struct	nstr nstr;
	extern	char *masktopath();
	extern  float mcost();
	extern  float pathtoxy();
	char	*path;
	int	dstx;
	int	dsty;

	if (snxtsct(&nstr, argp[1]) < 0)
		return 2;
	prdate();
	dirstr = ".      $";
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			if (god)
				pr("   ");
			pr("DUMP SECTOR\n");
			if (god)
				pr("own ");
			pr("x y des sdes eff mob * ");
			pr("min gold fert ocontent uran work terr ");
			pr("civ mil uw food shell gun pet iron ");
			pr("dust bar oil lcm hcm rad ");
			pr("u_del f_del s_del g_del p_del i_del ");
			pr("d_del b_del o_del l_del h_del r_del ");
			pr("u_cut f_cut s_cut g_cut p_cut i_cut ");
			pr("d_cut b_cut o_cut l_cut h_cut r_cut ");
			pr("dist_path dist_x dist_y ");
			pr("u_dist f_dist s_dist g_dist p_dist i_dist ");
			pr("d_dist b_dist o_dist l_dist h_dist r_dist\n");
		}
/* census */
		if (god)
			pr(fmt("%d ", sect.sct_own));
		pr(fmt("%d %d ", nstr.n_x, nstr.n_y));
		pr(fmt("%c ", dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c ", dchr[sect.sct_newtype].d_mnem));
		else
			pr("_ ");
		pr(fmt("%d ", sect.sct_effic));
		pr(fmt("%d ", sect.sct_mobil));
		pr(fmt("%c ", sect.sct_own != sect.sct_oldown ? '*' : '.'));
		pr(fmt("%d ", sect.sct_min));
		pr(fmt("%d ", sect.sct_gmin));
		pr(fmt("%d ", sect.sct_fertil));
		pr(fmt("%d ", sect.sct_oil));
		pr(fmt("%d ", sect.sct_uran));
		pr(fmt("%d ", sect.sct_work));
	    	pr(fmt("%d ", sect.sct_terr));
		pr(fmt("%d ", gsctv(V_CIVIL)));
		pr(fmt("%d ", gsctv(V_MILIT)));
		pr(fmt("%d ", gsctv(V_UW)));
		pr(fmt("%d ", gsctv(V_FOOD)));
/* commodity */
		pr(fmt("%d ", gsctv(V_SHELL)));
		pr(fmt("%d ", gsctv(V_GUN)));
		pr(fmt("%d ", gsctv(V_PETROL)));
		pr(fmt("%d ", gsctv(V_IRON)));
		pr(fmt("%d ", gsctv(V_DUST)));
		pr(fmt("%d ", gsctv(V_BAR)));
		pr(fmt("%d ", gsctv(V_OIL)));
		pr(fmt("%d ", gsctv(V_LCM)));
		pr(fmt("%d ", gsctv(V_HCM)));
		pr(fmt("%d ", gsctv(V_RAD)));
/* cutoff */
		pr(fmt("%c ", dirstr[gsctv(V_UDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_FDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_SDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_GDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_PDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_IDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_DDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_BDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_ODEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_LDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_HDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_RDEL) & 0x7]));
		pr(fmt("%d ", gsctv(V_UDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_FDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_SDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_GDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_PDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_IDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_DDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_BDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_ODEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_LDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_HDEL) & ~0x7));
		pr(fmt("%d ", gsctv(V_RDEL) & ~0x7));
/* level */
		path = masktopath(sect.sct_distpath);
		dstx = nstr.n_x;
		dsty = nstr.n_y;
		(void) pathtoxy(path, &dstx, &dsty, mcost);
		pr(fmt("%s ", *path ? path : "_"));
		pr(fmt("%d %d ", dstx, dsty));
		pr(fmt("%d ", gsctv(V_UDIST)));
		pr(fmt("%d ", gsctv(V_FDIST)));
		pr(fmt("%d ", gsctv(V_SDIST)));
		pr(fmt("%d ", gsctv(V_GDIST)));
		pr(fmt("%d ", gsctv(V_PDIST)));
		pr(fmt("%d ", gsctv(V_IDIST)));
		pr(fmt("%d ", gsctv(V_DDIST)));
		pr(fmt("%d ", gsctv(V_BDIST)));
		pr(fmt("%d ", gsctv(V_ODIST)));
		pr(fmt("%d ", gsctv(V_LDIST)));
		pr(fmt("%d ", gsctv(V_HDIST)));
		pr(fmt("%d ", gsctv(V_RDIST)));
		pr("\n");
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return 0;
}
