static char *RCSid = "$Header: demo.c 1.5 89/03/17 $";


/*
 * demo.c
 *
 * de-mobilize "n" military in a given sector.
 * You get to pay $3/mil for "GI Bill", and the
 * sector must have at least 60% efficiency.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "nsc.h"

/*
 * format: demo <SECTS> number
 *
 */
demo() {
	extern	char *getstarg();
	extern	char *fmt();
	extern	struct sctstr sect;
	extern	char *argp[];
	extern	int god;
	extern	int owner;
	extern	int cnum;
	extern	struct natstr *natp;
	extern	double dolcost;
	struct	nstr nstr;
	int	mil_demob;
	int	mil;
	int	civ;
	int	deltamil;
	int	number;
	char	*p;
	int	reserves;

	if (snxtsct(&nstr, argp[1]) < 0)
		return RET_SYN;
	if ((p = getstarg(argp[2], "Number to de-mobilize :  ")) == 0)
		return RET_OK;
	number = atoi(p);
	if (!(p = getstarg(argp[3], "New civilians on active reserve? (y/n)")))
		return RET_OK;
	if (*p != 'y' && *p != 'n')
		return RET_SYN;
	mil_demob = 0;
	getnat(cnum);
	reserves = 0;
	while (nxtsct(&nstr, 0)) {
		if (!god && (!owner || sect.sct_effic < 60))
			continue;
#ifdef notdef
		if (sect.sct_type == SCT_URBAN)
			continue;
#endif
		if ((mil = gsctv(V_MILIT)) == 0)
			continue;
		if (sect.sct_own != sect.sct_oldown)
			continue;
		civ = gsctv(V_CIVIL);
		if (number < 0){
			if ((deltamil = mil + number) <= 0)
				continue;
		}
		else if ((deltamil = min(mil, number)) <= 0)
			continue;
		civ += deltamil;
		mil -= deltamil;
		mil_demob += deltamil;
		dolcost += (double) (deltamil * 5);
		pr(fmt("%d demobilized in %d,%d (%d)\n",
			deltamil, sect.sct_x, sect.sct_y, mil));
		if (*p == 'y')
			reserves += deltamil;
		psctv(V_MILIT, mil);
		psctv(V_CIVIL, civ);
		putsect(sect.sct_x, sect.sct_y);
	}
	pr(fmt("Total new civilians : %d\n", mil_demob));
	pr(fmt("Military reserve stands at %d\n",
		natp->nat_reserve + reserves));
	NAT_DELTA(nat_reserve, cnum, reserves);
	return RET_OK;
}
