static char *RCSid = "$Header: deli.c 1.8 89/03/17 $";

/*
 * deli.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "nsc.h"

int
deli()
{
	extern	struct ichrstr *whatitem();
	extern	char *getstring();
	extern	char *fmt();
	extern	char *index();
	extern	char *argp[];
	extern	int owner;
	extern	struct sctstr sect;
	extern	int diroff[][2];
	extern	struct dchrstr dchr[];
	extern	int sx, sy;
	register char *buf;
	register int dir;
	register struct ichrstr *ich;
	register int package;
	register int threshtype;
	int     threshval;
	int     threshn;
	int	dirn;
	int     threshold;
	int     deliv;
	int	i_del;
	struct nstr nst;

	if ((ich = whatitem(argp[1], "deliver what? ")) == 0)
		return RET_SYN;
	if (ich->i_vtype == V_CIVIL || ich->i_vtype == V_MILIT) {
		pr("You cannot deliver people!\n");
		return RET_SYN;
	}
	i_del = V_DEL(ich->i_vtype & ~VT_TYPE);

	/*
	**  Parse <THRESH> <DIR> or <DIR> <THRESH>.
	*/
	threshtype = ' ', threshval = 0;
	threshn = -1, dirn = -1;
	if (argp[3] != 0) {
		if (index("(+-"/*)*/, argp[3][0]) != 0) {
			threshn = 3;
			if (argp[4] != 0)
				dirn = 4;
		} else if (argp[4] != 0 && index("(+-"/*)*/, argp[4][0]) != 0) {
			threshn = 4;
			dirn = 3;
		} else if (argp[4] == 0)
			dirn = 3;
		else
			goto syntax;
		if (dirn != -1 && chkdir(argp[dirn][0], 0, 6) < 0)
			goto syntax;
		if(threshn != -1) {
			if (argp[threshn][0] == '(') {
				threshtype = '(';
				threshval = atopi(argp[threshn] + 1);
			} else if (argp[threshn][0] == '+') {
				threshtype = '+';
				threshval = atopi(argp[threshn] + 1);
			} else if (argp[threshn][0] == '-') {
				threshtype = '-';
			} else {
syntax:
				pr("syntax: deliver <ITEM> <SECTS> <DIR> <THRESH>\n");
				return RET_SYN;
			}
		}
	}

	if (snxtsct(&nst, argp[2]) == -1)
		return RET_SYN;
	if (threshtype != '-') {
		while (nxtsct(&nst, 1) > 0) {
			if (!owner)
				continue; 
			package = dchr[sect.sct_type].d_pkg;
			while (1) {
				threshold = threshval;
				if (threshtype == '+')
					break;
				if (dirn != -1 && argp[dirn] != 0)
					buf = argp[dirn];
				else {
					pr(fmt("Deliver %s from %s @ %d,%d ",
					       ich->i_name,
					       dchr[sect.sct_type].d_name,
					       nst.n_x, nst.n_y));
					buf = getstring("in which direction? ");
					if (*buf == 0)
						goto G0063;
				}
				dir = chkdir(*buf, 0, 6);
				if (dir >= 0) {
					if (dir == 0) {
						threshold = 0;
					} else {
#ifdef notdef
						/* XXX what the hell??? */
						getsect(nst.n_x+diroff[dir][0],
							nst.n_y+diroff[dir][1]);
#endif
						getsect(nst.n_x, nst.n_y);
						do {
							if (*buf == 0)
								goto G0043;
						} while (*buf++ != '(');
						threshold = atopi(buf);
					}
					goto G0043;
				}
				direrr("%c for no delivery, <CR> for no change.\n", 0, 0);
			}
			dir = gsctv(i_del) & 0x7;
G0043:
			/*package = threshold & ~0xf;*/
			package = threshold & ~0x7;
			if (psctv(i_del, package + dir) >= 0)
				putsect(nst.n_x, nst.n_y);
			else
				pr(fmt("No room for delivery path in %d,%d\n",
					nst.n_x, nst.n_y));
G0063:	
			;
		}
	} else {
		while (nxtsct(&nst, 1) > 0) {
			if (owner == 0)
				continue;
			deliv = gsctv(i_del);
			if (deliv != 0) {
				dir = deliv & 0x7;
				sx = diroff[dir][0] + nst.n_x;
				sy = diroff[dir][1] + nst.n_y;
				pr(fmt("Deliver %s from %s @ %d,%d to %d,%d",
				     ich->i_name, dchr[sect.sct_type].d_name,
				       nst.n_x, nst.n_y, sx, sy));
				if ((deliv & ~0x7) == 0)
					pr("\n");
				else
					pr(fmt(" (cutoff %d)\n", deliv & ~0x7));
			}
		}
	}
	return RET_OK;
}


