static char *RCSid = "$Header: decl.c 1.5 89/03/17 $";

/*
 * decl.c
 *
 * declare war, neutrality or alliance.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"

decl()
{
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *argp[];
	extern	int cnum;
	register char *r11;
	int	f4;
	int	f8;
	int	fc;

	r11 = getstarg(argp[1], "alliance, neutrality, hostility, or war? ");
	switch (*r11) {
	case 'a':
		f4 = ALLIED;
		break;
	case 'h':
		f4 = HOSTILE;
		break;
	case 'n':
		f4 = NEUTRAL;
		break;
	case 'w':
		f4 = AT_WAR;
		break;
	default:
		pr("That's no declaration!\n");
		return 2;
	}
	fc = natarg(argp[2], "with which country? ");
	if (fc < 0)
		return 2;
	if ((f8 = getrel(cnum, fc)) == f4) {
		pr("No change required for that!\n");
		return 1;
	}
	putrel(cnum, fc, f4);
	if (f4 == ALLIED) {
		pr("Congratulations.\n");
		nreport(cnum, N_DECL_ALLY, fc, 1);
		wu(0, fc, fmt("Country #%d has declared an alliance with you!",
			cnum));
	} else if (f4 == NEUTRAL) {
		if (f8 == 1)
			nreport(cnum, N_DIS_ALLY, fc, 1);
		else
			nreport(cnum, N_DIS_WAR, fc, 1);
		pr("Neutrality declared.\n");
		wu(0, fc, fmt("Country #%d has declared neutrality toward you!",
			cnum));
	} else if (f4 == HOSTILE) {
		pr("Another cold war...\n");
		wu(0, fc, fmt("Country #%d has become hostile!", cnum));
	} else if (f4 == AT_WAR) {
		pr("Declaration made (give 'em hell).\n");
		wu(0, fc, fmt("Country #%d has declared war on you!", cnum));
		nreport(cnum, N_DECL_WAR, fc, 1);
	}
	if (*(getstring("Change multiplier? ")) == 'y') {
		savnat(natp);
		commread();
		getnat(fc);
		multsingle(cnum, fc);
		rstnat();
	}
	return 0;
}
