static char *RCSid = "$Header: cuto.c 1.3 89/03/17 $";

/*
 * cuto.c
 *
 * do a delivery cutoff level report
 *
 * David Muir Sharnoff, 1987
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "news.h"

cuto()
{
	extern	char *fmt();
	extern	char *argp[];
	extern	char dirch[];
	extern	int god;
	extern	int owner;
	extern	struct dchrstr dchr[];
	extern	struct sctstr sect;
	extern  float mcost();
	int	nsect;
	int	n;
	struct	nstr nstr;
	char	*dirstr;

	if (snxtsct(&nstr, argp[1]) < 0)
		return 2;
	prdate();
	dirstr = ".      $";
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			pr("DELIVERY CUTOFF LEVELS\n");
			if (god) 
				pr(fmt("own"));
			pr("  sect    ufsgpidbolhr   uw food  sh gun pet iron dust bar oil lcm hcm rad\n");
		}
		if (god)
			pr(fmt("%2d ", sect.sct_own));
		pr(fmt("%3d,%-3d", nstr.n_x, nstr.n_y));
		pr(fmt(" %c ", dchr[sect.sct_type].d_mnem));
		pr(fmt("%c", dirstr[gsctv(V_UDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_FDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_SDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_GDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_PDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_IDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_DDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_BDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_ODEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_LDEL) & 0x7]));
		pr(fmt("%c", dirstr[gsctv(V_HDEL) & 0x7]));
		pr(fmt("%c ", dirstr[gsctv(V_RDEL) & 0x7]));
		pr(fmt("%4d", gsctv(V_UDEL) & ~0x7));
		pr(fmt("%5d", gsctv(V_FDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_SDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_GDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_PDEL) & ~0x7));
		pr(fmt("%5d", gsctv(V_IDEL) & ~0x7));
		pr(fmt("%5d", gsctv(V_DDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_BDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_ODEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_LDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_HDEL) & ~0x7));
		pr(fmt("%4d", gsctv(V_RDEL) & ~0x7));
		pr("\n");
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return 0;
}
