static char *RCSid = "$Header: coun.c 1.6 89/03/17 $";

/*
 * coun.c
 *
 * do a country roster.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"

coun()
{
	extern	char *fmt();
	extern	char *ctime();
	extern	char *argp[];
	extern	struct natstr *natp;
	extern	int natf;
	extern	int maxnoc;
	extern	struct sctstr sect;
	register char *r11;
	register int r10;

	/*
	 * just a deity command, so we can get away with gross hacks
	 * like this one.  At least this is better than setting all the
	 * nation variables to "notify".
	 */
	getnat(0);
	lseek(natf, 0L, 0);
	read(natf, natp, MAXNOC*sizeof(*natp));
	prdate();
	pr("  #   last access       time\tstatus\t country name\n");
	for (r10 = 0; r10 < maxnoc && getnat(r10) != 0; r10++) {
		if ((natp->nat_stat & STAT_INUSE) == 0)
			continue;
		pr(fmt("%3d  %-16.16s   [%d]", r10, natp->nat_login ?
			" Now logged on" : ctime(&natp->nat_date),
			natp->nat_btu));
		switch (natp->nat_stat & (STAT_NORM|STAT_GOD|STAT_NEW) {
		case 0:
			r11 = "Visitor";
			break;
		case STAT_NEW:
			r11 = "New";
			break;
		case STAT_NORM:
			getsect(capxof(r10), capyof(r10));
			if (sect.sct_own != r10 ||
			    (sect.sct_type != SCT_SANCT &&
			    sect.sct_type != SCT_CAPIT))
				r11 = "In flux";
			else if (natp->nat_money < 0)
				r11 = "Broke";
			else if (sect.sct_type == SCT_SANCT)
				r11 = "Sanctuary";
			else
				r11 = "Active";
			break;
		case (STAT_GOD|STAT_NORM):
			r11 = "DEITY";
			break;
		default:
			r11 = "Buggy";
			break;
		}
		pr(fmt("\t%-7.7s\t %s\n", r11, natp->nat_cnam));
	}
	return 0;
}
