static char *RCSid = "$Header: cons.c 1.4 89/03/17 $";

/*
 * cons.c
 *
 * consider loan or treaty
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "loan.h"
#include "nat.h"
#include "treaty.h"
#include "news.h"

int     adorp();

int
cons()
{
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *ctime();
	extern	char *argp[];
	extern	struct natstr *natp;
	extern	struct lonstr loan;
	extern	struct trtstr trty;
	extern	int cnum;
	extern	double dolcost;
	register int i;
	register int item_number;
	register char *buf;
	register int proposer;
	register int proposee;
	register int mailee;

	buf = getstarg(argp[1], "loan or treaty? ");
	if (buf == 0 || (*buf != 'l' && *buf != 't')) {
		pr("You must specify \"loan\" or \"treaty\".\n");
		return RET_SYN;
	}
	if (*buf == 't') 
		goto treaty;
	item_number = onearg(argp[2], "loan number? ");
	if (item_number == -1)
		return RET_SYN;
	if (disloan(item_number) <= 0) {
		pr(fmt("Loan #%d is not being offered to you!\n", item_number));
		return RET_SYN;
	}
	if (loan.l_amtpaid != -1) {
		pr("That loan has already been accepted!");
		return RET_FAIL;
	}
	proposer = loan.l_loner;
	proposee = loan.l_lonee;
	if (proposer != cnum)
		mailee = proposer;
	else
		mailee = proposee;
	i = adorp(argp[3]);
	if (i == 'a') {
		if (proposee != cnum) {
			pr(fmt("Loan %d is still pending.\n", item_number));
			return RET_OK;
		}
		getloan(item_number);
		if (loan.l_ldur == 0 && loan.l_lonee != cnum) {
			pr("Too late; that loan is no longer being offered.");
			return RET_OK;
		}
		getnat(proposer);
		if (natp->nat_money < loan.l_amtdue) {
			loan.l_amtdue = natp->nat_money - 100;
			pr(fmt("%s no longer has the funds...\n",
				cname(proposer)));
			if (loan.l_amtdue < 0)
				return RET_FAIL;
			pr(fmt("You may borrow $%d at the same terms\n",
				loan.l_amtdue));
		}
		sigsave();
		NAT_DELTA(nat_money, proposer, -loan.l_amtdue);
		dolcost -= loan.l_amtdue;
		loan.l_amtpaid = 0;
		(void) time(&loan.l_lastpay);
		loan.l_duedate = loan.l_ldur * 86400 + loan.l_lastpay;
		putloan(item_number);
		pr(fmt("You are now $%d richer (sort of)\n", loan.l_amtdue));
		wu(0, proposer, fmt("Loan %d accepted by country #%d",
			item_number, cnum));
		nreport(proposer, N_MAKE_LOAN, cnum, 1);
	} else if (i == 'p') {
		pr(fmt("Loan %d is still pending.\n", item_number));
		if (proposee == cnum)
			wu(0, proposer, fmt("Loan %d considered by country #%d",
					    item_number, cnum));
	} else if (i == 'd') {
		getloan(item_number);
		if (loan.l_amtpaid != -1) {
			pr("Too late; that loan has already been accepted!");
			return RET_OK;
		}
		loan.l_ldur = 0;
		putloan(item_number);
		if (proposee == cnum) {
			wu(0, proposer, fmt("Loan %d refused by country #%d",
				item_number, cnum));
			pr(fmt("Loan %d refused\n", item_number));
		} else {
			wu(0, proposee,
				fmt("Loan offer %d retracted by country #%d",
				item_number, cnum));
			pr(fmt("Loan offer %d retracted\n",
				item_number));
		}
	}
	return RET_OK;

treaty:
	item_number = onearg(argp[2], "Treaty number? ");
	if (item_number == -1)
		return RET_SYN;
	if (distrea(item_number) <= 0) {
		pr(fmt("You are not involved in treaty #%d!\n", item_number));
		return RET_SYN;
	}
	proposer = trty.trt_cna;
	proposee = max(trty.trt_cnb, -trty.trt_cnb);
	if (trty.trt_cnb > 0) {
		pr(fmt("Treaty #%d is already in effect\n", item_number));
		return RET_SYN;
	}
	if (proposer != cnum)
		mailee = proposer;
	else
		mailee = proposee;
	i = adorp(argp[3]);
	if (i == 'a' && trty.trt_cnb == -cnum) {
		trty.trt_cnb = cnum;
		wu(0, mailee, fmt("Treaty #%d accepted by country #%d",
			item_number, cnum));
		nreport(cnum, N_SIGN_TRE, mailee, 1);
	} else if (i == 'd') {
		trty.trt_cna = trty.trt_cnb = 0;
		if (proposee != cnum)
			wu(0, mailee, fmt("Treaty offer #%d retracted",
				item_number));
		else
			wu(0, mailee, fmt("Treaty #%d refused", item_number));
	} else {
		wu(0, mailee, fmt("Treaty %d considered by country #%d",
			item_number, cnum));
	}
	puttre(item_number);
	if (trty.trt_cna <= 0 || trty.trt_cnb <= 0) {
		if (trty.trt_cna != 0)
			pr("The treaty is still pending\n");
		else
			pr("The treaty is now void\n");
		return RET_OK;
	} else {
		pr(fmt("Treaty in effect until %s", ctime(&trty.trt_exp)));
		return RET_OK;
	}
}

adorp(arg)
	char   *arg;
{
	extern	char *getstarg();	
	register char *buf;

	while (1) {
		buf = getstarg(arg, "Accept, decline or postpone? ");
		if (*buf == 'a' || *buf == 'd' || *buf == 'p')
			break;
		arg = 0;
	}
	return *buf;
}
