
static char *RCSid = "$Header: carg.c 1.2 89/03/17 $";

/*
 * carg.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "nsc.h"

carg()
{
	extern	char *splur();
	extern	char *fmt();
	extern	char *argp[];
	extern	struct mchrstr mchr[];
	extern	int cnum;
	register int nships;
	register struct shpstr *sp;
	struct	nbstr nb;
	struct	shpstr s;

	if (snxtshp(&nb, argp[1], cnum, "")+1 == 0)
		return RET_SYN;
	nships = 0;
	sp = &s;
	while (nxtshp(&nb, sp)) {
		extern	int shp_maxno;
		if (sp->shp_type < 0 || sp->shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
				sp->shp_type, nb.nb_sno));
			continue;
		}
		if (nships++ == 0) {
pr("shp#     ship type      x,y   flt eff   sh gun pet irn dst bar oil lcm hcm rad\n");
		}
		pr(fmt("%4d ", nb.nb_sno));
		pr(fmt("%-16.16s ", mchr[sp->shp_type].m_name));
		pr(fmt("%3d,%-3d ", sp->shp_x, sp->shp_y));
		pr(fmt(" %1c ", sp->shp_fleet));
		pr(fmt("%4d%%", sp->shp_effic));
		pr(fmt("%4d", gshpv(V_SHELL, sp)));
		pr(fmt("%4d", gshpv(V_GUN, sp)));
		pr(fmt("%4d", gshpv(V_PETROL, sp)));
		pr(fmt("%4d", gshpv(V_IRON, sp)));
		pr(fmt("%4d", gshpv(V_DUST, sp)));
		pr(fmt("%4d", gshpv(V_BAR, sp)));
		pr(fmt("%4d", gshpv(V_OIL, sp)));
		pr(fmt("%4d", gshpv(V_LCM, sp)));
		pr(fmt("%4d", gshpv(V_HCM, sp)));
		pr(fmt("%4d\n", gshpv(V_RAD, sp)));
	}
	if (nships == 0) {
		pr(fmt("%s: No ship(s)\n", (argp[1] == 0) ? "" : argp[1]));
		return RET_FAIL;
	}
	pr(fmt("%d ship%s\n", nships, splur(nships)));
	return RET_OK;
}
