static char *RCSid = "$Header: capi.c 1.10 89/03/17 $";

/*
 * capi.c
 *
 * move your capital
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"

capi() {
	extern	char *fmt();
	extern	char *argp[];
	extern	struct sctstr sect;
	extern	int capx, capy;
	extern	struct natstr *natp;
	extern	int cnum;
	extern	int nstat;

	if (getsno(argp[1], "New cap location : ") < 0)
		return RET_SYN;
	if (sect.sct_own != cnum) {
		pr(fmt("Sector %d,%d does not belong to you!\n",
			sect.sct_x, sect.sct_y));
		return RET_FAIL;
	}
	if (sect.sct_type != SCT_CAPIT) {
		pr(fmt("Sector %d,%d is not a capital!\n",
			sect.sct_x, sect.sct_y));
		return RET_FAIL;
	}
	getnat(cnum);
	if (xwrap(sect.sct_x) == xwrap(natp->nat_xcap - natp->nat_xorg) && 
	    ywrap(sect.sct_y) == ywrap(natp->nat_ycap - natp->nat_yorg) &&
	    sect.sct_type == SCT_CAPIT) {
		pr(fmt("%d,%d is already your capital.\n",
			sect.sct_x, sect.sct_y));
		return RET_FAIL;
	}
	nstat |= CAP;
	capx = natp->nat_xcap = xwrap(natp->nat_xorg + sect.sct_x);
	capy = natp->nat_ycap = ywrap(natp->nat_yorg + sect.sct_y);
#ifdef DEBUG_ORIGIN
	pr(fmt("natset cap %d,%d (%d+%d,%d+%d)\n",
		xwrap(natp->nat_xorg + sect.sct_x),
		ywrap(natp->nat_yorg + sect.sct_y),
		natp->nat_xorg, sect.sct_x,
		natp->nat_yorg, sect.sct_y));
#endif
	NAT_SET(nat_xcap, cnum, capx);
	NAT_SET(nat_ycap, cnum, capy);
	pr(fmt("Capitol now at %d,%d.\n",
		xwrap(sect.sct_x), ywrap(sect.sct_y)));
	return 0;
}
