static char *RCSid = "$Header: buy.c 1.8 89/03/17 $";

/*
 * buy.c
 *
 * engage in inter-nation trading of commodities.
 * each nation has a list of prices, and multipliers for
 * other nations.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"
#include "trade.h"

/*
 * format: buy <COMMODITY>
 *
 */
buy() {
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *getstring();
	extern	struct ichrstr *whatitem();
	extern	char *argp[];
	extern	int cnum;
	extern	int god;
	extern	struct sctstr sect;
	extern	struct natstr *natp;
	extern	int maxnoc;
	extern	double dolcost;
	int	qty;
	int	number;
	float	price;
	int	amt;
	int	n;
	int	i;
	char	*p;
	struct	ichrstr *ip;
	int	product;

	ip = whatitem(argp[1], "which commodity : ");
	if (ip == 0)
		return RET_OK;
	if (ip->i_sell == 0) {
		pr(fmt("%s cannot be traded!\n", ip->i_name));
		return RET_OK;
	}
	product = ip->i_vtype & ~VT_TYPE;
	commread();
	n = 0;
	if (argp[2] == 0) {
		/*
		 * if user didn't supply arg, then show what's on sale
		 */
		number = 0;
		for (i=0; i<maxnoc; i++) {
			if ((amt = commamt(i, product, &price)) == 0)
				continue;
			if (number == 0) {
				pr(fmt("Trade report : %s\n", ip->i_name));
				pr(" cnum      country   amount  item price\n");
			}
			pr(fmt("(#%2d) %12.12s %7d %7.2f", i, cname(i),
				amt, price));
			if (i == cnum && !god)
				pr(" (your own lot)\n");
			else
				pr("\n");
			number++;
		}
		if (number == 0) {
			pr(fmt("No countries are selling %s\n", ip->i_name));
			return RET_OK;
		}
	}
	if ((number = natarg(argp[2], "Buy from : ")) < 0)
		return RET_SYN;
	if (number == cnum) {
		pr("You can't buy from yourself!\n");
		return RET_FAIL;
	}
	amt = commamt(number, product, &price);
	if (amt <= 0) {
		pr(fmt("%s wasn't selling %s\n", cname(number), ip->i_name));
		return RET_OK;
	}
	p = getstarg(argp[3],
		fmt("Number of %s to buy (max %d) : ", ip->i_name, amt));
	if (p == 0 || *p == 0)
		return RET_OK;
	if ((qty = atoi(p)) < 0 || qty > amt)
		return RET_FAIL;
	if (natp->nat_money < price * qty) {
		pr(fmt("You don't have %8.3f to spend!\n", price * qty));
		return RET_OK;
	}
	if (getsno(argp[4], "destination sector : ") == -1)
		return RET_SYN;
	if (!god && (sect.sct_type != SCT_WAREH || sect.sct_own != cnum)) {
		pr("Destination sector is not a warehouse!\n");
		return RET_OK;
	}
	if (!god && sect.sct_effic < 60) {
		pr("Sector under construction\n");
		return RET_OK;
	}
	n = gsctv(ip->i_vtype);
	if (qty + n > 9990) {
		pr("Sector cannot hold that much!\n");
		return RET_OK;
	}
	sigsave();
	if (commlock() < 0) {
		pr("Cannot lock comm file!\n");
		return RET_OK;
	}
	commread();
	if (commamt(number, product, &price) != amt) {
		communlock();
		pr("Oops...comm info changed while you were deciding\n");
		return RET_OK;
	}
	if (psctv(ip->i_vtype, n + qty) < 0) {
		pr(fmt("No room to store %s in %d,%d\n",
			ip->i_name, sect.sct_x, sect.sct_y));
		communlock();
		return 0;
	}
	putsect(sect.sct_x, sect.sct_y);
	commset(number, product, -qty);
	commwrite();
	communlock();
	NAT_DELTA(nat_money, number, (int) ((price*qty) + 0.5));
	nreport(number, N_MAKE_SALE, cnum, 1);
	wu(0, number, fmt("%s bought %d %s from you for $%.2f",
		cname(cnum), qty, ip->i_name, price * qty));
	dolcost += (price * qty) + 0.5;
	sigrest();
	return RET_OK;
}
