static char *RCSid = "$Header: boar.c 1.7 89/03/17 $";

/*
 * boar.c
 *
 * board an enemy ship
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "news.h"

boar()
{
	extern	double techfact();
	extern	double shipdef();
	extern	char *fmt();
	extern	char *argp[];
	extern	struct mchrstr mchr[];
	extern	int cnum;
	extern	int btused;
	register int r11;
	int	dshpno;		/* defending shipno */
	int	ashpno;		/* attacking shipno */
	int	amil;		/* # attacking mil */
	int	dmil;		/* # defending mil */
	int	d_cnum;		/* defender cnum */
	int	a_x;		/* attacker x */
	int	a_y;		/* attacker y */
	int	d_x;		/* defender x */
	int	d_y;		/* defender y */
	int	acas;		/* attacker casualties */
	int	dcas;		/* defender casualties */
	int	f30;		/* return from seadef() */
	int	f34;		/* damage from shipdef() */
	struct	shpstr aship;	/* attacking ship */
	struct	shpstr dship;	/* defending ship */
	double	aspeed;
	double	dspeed;

	if ((dshpno = getshno(argp[1], "Victim ship? ", &dship)) == -1) {
		pr("No such ship\n");
		return RET_SYN;
	}
	d_cnum = dship.shp_own;
	if (trechk(cnum, d_cnum, 1) == -1)
		return RET_FAIL;
	d_x = dship.shp_x;
	d_y = dship.shp_y;
	ashpno = getshno(argp[2], "Boarding party from ship #", &aship);
	if (ashpno == -1 || aship.shp_own != cnum)
		return RET_FAIL;
	a_x = aship.shp_x;
	a_y = aship.shp_y;
	if (a_x != d_x || a_y != d_y) {
		pr("Not adjacent\n");
		return RET_FAIL;
	}
	if ((amil = gshpv(V_MILIT, &aship)) == 0) {
		pr(fmt("No military on %s #%d\n",
			mchr[aship.shp_type].m_name, ashpno));
		return RET_FAIL;
	}
	if (aship.shp_mobil <= 0) {
		pr(fmt("%d #%d has no mobility!\n",
			mchr[aship.shp_type].m_name, ashpno));
		return RET_FAIL;
	}
	if ((r11 = wethr(a_y, a_x, 0)) < 730) {
		pr(fmt("Barometer @%.0f; seas too rough to board...", r11));
		return RET_FAIL;
	}
	if (mchr[dship.shp_type].m_visib <= 2) {
		pr("You can't board a submarine!\n");
		return RET_FAIL;
	}
	f30 = seadef(aship.shp_type);
	sigsave();
	f34 = shipdef(d_cnum, f30, a_x, a_y);
	if (f34 == 0)
		goto LL11;
	wu(0, d_cnum, fmt("Return fire did %d%% damage to %s #%d",
		f34, mchr[aship.shp_type].m_name, ashpno));
	getship(ashpno, &aship);
	shipdamage(&aship, f34);
	putship(ashpno, &aship);
	if (aship.shp_own != 0)
		goto LL11;
	wu(0, d_cnum, fmt("Country #%d lost %s #%d trying to board %s #%d",
		cnum, mchr[aship.shp_type].m_name, ashpno,
		mchr[dship.shp_type].m_name, dshpno));
	nreport(cnum, N_SHP_LOSE, d_cnum, 1);
	return 0;
LL11:
	getship(ashpno, &aship);
	getship(dshpno, &dship);
	if (dship.shp_mobil > 0) {
		aspeed = mchr[aship.shp_type].m_speed *
			aship.shp_effic / 100.0;
		dspeed = mchr[dship.shp_type].m_speed * 
			dship.shp_effic / 100.0;
		aspeed = techfact(aship.shp_tech, 1.0) * aspeed;
		dspeed = techfact(dship.shp_tech, 1.0) * dspeed;
		aship.shp_mobil -= 127.0 / aspeed;
		putship(ashpno, &aship);
		dship.shp_mobil -= 127.0 / aspeed;
		putship(dshpno, &dship);
		if (aspeed < dspeed) {
			pr("Victim ship moves faster than you do!");
			pr("  You can't catch him!\n");
			wu(0, dship.shp_own,
				fmt("%s (#%d) %s #%d failed to catch %s #%d\n",
				cname(aship.shp_own), aship.shp_own,
				mchr[aship.shp_type].m_name, ashpno,
				mchr[dship.shp_type].m_name, dshpno));
			return 0;
		}
	}
	amil = gshpv(V_MILIT, &aship);
	dmil = gshpv(V_MILIT, &dship);
	pr(fmt("%d attempting to board ship #%d\n", amil, dshpno));
	acas = dcas = 0;
	while (1) {
		if (chance(0.33) || dmil <= 0) {
			pr("!");
			dcas++;
			if (--dmil <= 0)
				break;
		} else { 
			pr("@");
			acas++;
			if (--amil <= 0)
				break;
		}
#ifdef notdef
		if (chance(0.66))
			sleep(1);
#endif
	}
	getship(ashpno, &aship);
	getship(dshpno, &dship);
	if (amil > 0) {

		pr("Boarding successful!\n");
		wu(0, d_cnum, fmt("Country #%d boarded %s #%d\n", cnum,
			mchr[dship.shp_type].m_name, dshpno));
		nreport(cnum, N_BOARD_SHIP, d_cnum, 1);
		takeover_ship(&dship, cnum);
		dship.shp_fleet = ' ';
		r11 = getvar(V_MILIT, &mchr[dship.shp_type], GT_MCHR);
		dmil = min(amil / 2, r11);
		amil -= dmil;
		pr(fmt("%d of your troops hold%s ship %d\n", dmil,
			dmil == 1 ? "s" : "", dshpno));
		pr(fmt("%d return%s to ship %d\n", amil,
			amil == 1 ? "s" : "", ashpno));
		if (gshpv(V_PSTAGE, &dship) == PLG_INFECT) {
			if (gshpv(V_PSTAGE, &aship) == 0)
				pshpv(V_PSTAGE, PLG_EXPOSED, &aship);
		}
		if (gshpv(V_PSTAGE, &aship) == PLG_INFECT)
			if (gshpv(V_PSTAGE, &dship) == 0)
				pshpv(V_PSTAGE, PLG_EXPOSED, &dship);
#ifdef notdef
		if ((civ = gshpv(V_CIVIL, &dship)) > 0)
			pshpv(V_UW, &dship, civ);
		if ((uw = gshpv(V_UW, &dship)) > 0)
			pshpv(V_CIVIL, &dship, uw);
#endif
	} else {
		pr("\nYou have been repelled...\n");
		wu(0, d_cnum, fmt("Country #%d %s #%d tried to board %s #%d",
			cnum, mchr[aship.shp_type].m_name, ashpno,
			mchr[dship.shp_type].m_name, dshpno));
		nreport(cnum, N_SHP_LOSE, d_cnum, 1);
	}
	pshpv(V_MILIT, amil, &aship);
	putship(ashpno, &aship);
	pshpv(V_MILIT, dmil, &dship);
	putship(dshpno, &dship);
	pr(fmt("Casualties :\nYours ... %d\n", acas));
	pr(fmt("Theirs .. %d\n", dcas));
	pr(fmt("Papershuffling ... %.1f B.T.U\n", (dcas + acas) * 0.15));
	btused += ((dcas + acas) * 0.15) + 0.5;
	return 0;
}
