static char *RCSid = "$Header: atta.c 1.10 89/03/17 $";

/*
 * atta.c
 *
 * attack another sector.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "news.h"

static struct	unit {
	short	x;
	short	y;
	float	def;
	short	troops;
	int	des;
	int	eff;
} unit[7];

atta()
{
	extern	double calcodds();
	extern	double dmax();
	extern	double defdef();
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *argp[];
	extern	int lx, ly;
	extern	struct dchrstr dchr[];
	extern	struct sctstr sect;
	extern	int diroff[][2];
	extern	int cnum;
	extern	int btused;
	register int n;
	register int a_nsect;	/* number of attacking sectors */
	int	d_cnum;
	int	x;
	int	y;
	int	off_x;
	int	off_y;
	int	o_mil;		/* occupation troops */
	int	d_mil;		/* total defending mil */
	int	mil;
	int	movein;
	int	a_mil;
	int	a_total;	/* total attacking mil */
	int	i;
	int	s;
	int	type;
	int	mob_support;
	int	success;
	int	mcst;
	int	mcost;
	int	dam;
	int	plague;
	int	d_cas;
	int	a_cas;
	float	saveodds;
	double	f60;
	double	f68;
	double	f70;
	double	f7c;
	struct	dchrstr *dp;
	char	*p;

	if (sargs(argp[1]) < 0 || getsect(lx, ly) < 0)
		return 2;
	if (neigh(lx, ly, cnum) == 0) {
		pr(fmt("You are not adjacent to %d,%d\n", lx, ly));
		return 1;
	}
	p = getstarg(argp[2], "Move in if victorious? ");
	if (p == 0 || *p == 'n')
		movein = 0;
	else
		movein = 1;
	d_cnum = sect.sct_own;
	type = sect.sct_type;
	dp = &dchr[type];
	if ((mcst = dp->d_mcst) <= 0) {
		pr(fmt("You can't attack a %s.\n", dchr[sect.sct_type].d_name));
		return 2;
	}
	if (sect.sct_own == cnum) {
		pr("You can't attack your own sector!\n");
		return 2;
	}
	if (sect.sct_own && trechk(cnum, sect.sct_own, 4) < 0)
		return 1;
	plague = gsctv(V_PSTAGE) == PLG_INFECT ? 1 : 0;
	unit[6].x = x = lx;
	unit[6].y = y = ly;
	unit[6].troops = d_mil = gsctv(V_MILIT);
	pr(fmt("%d,%d is a %d%% %s with %d military or so.\n",
		x, y, round(sect.sct_effic, 10), dp->d_name,
		round(d_mil, 10)));
	if (wethr(x, y, 0) < 730)
		pr(" Inclement weather\07...\n");
	unit[6].des = sect.sct_type;
	unit[6].eff = sect.sct_effic;
	a_total = 0;
	a_nsect = 0;
	for (n = 1; n <= 6; n++) {
		off_x = x + diroff[n][0];
		off_y = y + diroff[n][1];
		if (getsect(off_x, off_y) < 0)
			continue;
		if (sect.sct_own != cnum || dchr[sect.sct_type].d_ostr < 1)
			continue;
		mcost = dchr[sect.sct_type].d_mcst + mcst * 2;
		mob_support = sect.sct_mobil * 24 / mcost;
		mil = gsctv(V_MILIT);
		if (mil > mob_support) {
			pr(fmt("The %d mobility units in %d,%d will only",
				sect.sct_mobil, off_x, off_y));
			pr(fmt(" support %d troops, \n", mob_support));
		} else {
			mob_support = mil;
			if (mob_support == 0)
				pr(fmt("No troops in %d,%d\n", off_x, off_y));
		}
		if (mob_support == 0)
			continue;
		pr(fmt("Number of troops from %s at %d,%d (max %d) : ",
			dchr[sect.sct_type].d_name, off_x, off_y, mob_support));
		a_mil = atopi(getstring(""));
		if (a_mil == 0)
			continue;
		getsect(off_x, off_y);
		a_mil = min(a_mil, min(mob_support, mil));
		a_total += a_mil;
		sect.sct_mobil -= (int) ((float) a_mil / (24.0/(float) mcost));
		putsect(off_x, off_y);
		unit[a_nsect].x = off_x;
		unit[a_nsect].y = off_y;
		unit[a_nsect].troops = a_mil;
		unit[a_nsect].des = sect.sct_type;
		unit[a_nsect].eff = sect.sct_effic;
		a_nsect++;
		if (gsctv(V_PSTAGE) == PLG_INFECT)
			plague++;
	}
	if (a_total <= 0) {
		wu(0, d_cnum, fmt("Country #%d considered attacking you @%s",
			cnum, xytoa(x, y, d_cnum)));
		pr("No troops in attack...\n");
		return 1;
	}
	f68 = calcodds(a_nsect);
	saveodds = f68;
	pr(fmt("Your combat odds are %.1f%%\n", f68 * 100.0));
	a_cas = 0;
	d_cas = a_cas;
	/*
	 * defender sector replying with gunfire: pick
	 * a random attacking sector to blast.
	 */
	n = rand() % a_nsect;
	dam = 0;
	if (f68 > 0.30) {
		/*
		 * only bother defending if the attacker has a chance
		 * of winning!
		 */
		if (getsect(unit[n].x, unit[n].y) == 0)
			dam = defdef(x, y, landdef(sect.sct_type), unit[n].x,
				unit[n].y);
		if (dam > 0) {
			f7c = gsctv(V_MILIT);
			f70 = f7c;
			sectdamage(unit[n].x, unit[n].y, dam);
			unit[n].eff = sect.sct_effic;
			putsect(unit[n].x, unit[n].y);
			f7c = gsctv(V_MILIT);
			f70 -= f7c;
			a_cas += f70;
			unit[n].troops -= f70;
			if (unit[n].troops < 0)
				unit[n].troops = 0;
			f68 = calcodds(a_nsect);
			pr(fmt("Your combat odds are now %.1f%%\n",
				f68 * 100.0));
		}
	}
	for (n=0; n<a_nsect; n++) {
		getsect(unit[n].x, unit[n].y);
		psctv(V_MILIT, gsctv(V_MILIT) - unit[n].troops);
		putsect(unit[n].x, unit[n].y);
	}
	success = 0;
	n = 0;
	while (1) {
		f68 = calcodds(a_nsect);
		if (chance(f68) == 0) {
			for (s = 0; s < a_nsect; s++) {
				i = (n + s) % a_nsect;
				if (unit[i].troops > 0)
					break;
			}
			/*
			 * termination condition
			 */
			if (s == a_nsect)
				break;
			if (--unit[i].troops == 0)
				pr("*");
			else
				pr("@");
			a_cas++;
			n++;
		} else {
			pr("!");
			if (--unit[6].troops <= 0) {
				success++;
				break;
			}
			d_cas++;
		}
	}
	pr("\n");
	if (success) {
		pr(fmt("You have captured %d,%d!\n", x, y));
		if (d_cnum)
			wu(0, d_cnum,fmt("Country #%d lost %d troops taking %s",
				cnum, a_cas, xytoa(x, y, d_cnum)));
		nreport(cnum, N_WON_SECT, d_cnum, 1);
		a_total = 0;
		for (n = 0; n < a_nsect; n++)
			a_total += unit[n].troops;
		if (movein) {
			f60 = 1.0 / (a_nsect + 1.0);
			f60 = dmax(f60, 1.0 / a_total);
		} else
			f60 = 0.0;
		o_mil = 0;
		for (n = 0; n < a_nsect; n++) {
			getsect(unit[n].x, unit[n].y);
			i = unit[n].troops * f60 + 0.5;
			if (i + o_mil > 999)
				i = 999 - o_mil;
			if (i > 0) {
				o_mil += i;
				unit[n].troops -= i;
			}
			/*
			 * possibility that the sector might be "lost"
			 * when no civ and no mil exist in the sector.
			 */
			if (sect.sct_own == 0) {
				setown(sctoff(sect.sct_x, sect.sct_y),
					0, cnum, 1);
				sect.sct_own = cnum;
			}
			if (unit[n].troops > 0) {
				pr(fmt("%d troops return to %d,%d\n",
					unit[n].troops, unit[n].x, unit[n].y));
				if (plague && gsctv(V_PTIME) == 0)
					psctv(V_PTIME, PLG_EXPOSED);
			}
			psctv(V_MILIT, gsctv(V_MILIT) + unit[n].troops);
			putsect(unit[n].x, unit[n].y);
		}
		if (movein)
			pr(fmt("%d of your troops now occupy %d,%d\n",
				o_mil, x, y));
		else
			pr(fmt("None of your troops occupy %d,%d\n", x, y));
		if (type == SCT_CAPIT)
			caploss(x, y, d_cnum,
				"You have captured %s's capital!\n");
	} else {
		pr("You have been defeated!\n");
		nreport(cnum, N_SCT_LOSE, d_cnum, 1);
		o_mil = unit[6].troops;
		if (d_cnum)
			wu(0, d_cnum,
				fmt("Country #%d lost %d troops attacking %s",
				cnum, a_cas, xytoa(x, y, d_cnum)));
		plague = 0;
	}
	pr(fmt("Casualties :\012Yours ... %d\n", a_cas));
	pr(fmt("Theirs .. %d\n", d_cas));
	pr(fmt("Papershuffling ... %.1f B.T.U\012", (d_cas + a_cas) * 0.15));
	btused += (d_cas + a_cas) * 0.15 + 0.5;
	getsect(x, y);
	/*
	 * subtract defender's mobility from sector based
	 * on the number of attackers.  This way we won't get
	 * 1 attacking military zeroing the mob in the defender's
	 * sector.
	 */
	n = sect.sct_mobil -
		((saveodds > 0.25) ? (d_mil / (24.0 / (float)mcost)) : 1);
	if (success) {
		o_mil = takeover(&sect, o_mil);
		sect.sct_mobil = 0;
		psctv(V_CHKPT, 0);
	} else {
		sect.sct_own = d_cnum;
		sect.sct_mobil = n < 0 ? 0 : n;
	}
	psctv(V_MILIT, o_mil);
	if (plague)
		if (gsctv(V_PSTAGE) == 0)
			psctv(V_PSTAGE, PLG_EXPOSED);
	putsect(x, y);
	return 0;
}

double
calcodds(nsect)
	int	nsect;
{
	register int n;
	register int troops;
	double	att_str;
	double	def_str;
	double	odds;
	double	eff;

	att_str = 0.0;
	def_str = 0.0;
	for (n = 0; n <= 6; n++) {
		if (n >= nsect)
			n = 6;
		troops = unit[n].troops;
		eff = unit[n].eff / 100.0;
		if (n == 6) {
			eff = (dchr[unit[n].des].d_dstr / 2.0 - 1.0) *
				eff + 1.0;
			def_str += (troops * eff);
		} else {
			eff = (dchr[unit[n].des].d_ostr / 2.0 - 1.0) *
				eff + 1.0;
			att_str += (eff * troops);
		}
		unit[n].def = eff;
	}
	if (att_str <= 0.0)
		odds = 0.0;
	else
		odds = att_str / (def_str + att_str);
	n = wethr(unit[6].x, unit[6].y, 0);
	if (n < 760)
		odds *= n / 760.0;
	return odds;
}
