/* census.c - census routines */

/*
 * $Log:	special.c,v $
 * Revision 1.3  89/02/22  20:03:48  muir
 * indent and lint processed
 * 
 * Revision 1.2  88/08/15  19:18:35  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/special.c,v 1.3 89/02/22 20:03:48 muir Exp $";
#endif

# include "ve.h"

/*
 * Special file processing functions
 *
 * These routines parse the information from the "special" file,
 *
 * Hacked in by Steven Grady -- grady@postgres.berkeley.edu
 */

/*
 * special - Read and process special file.
 */
special(fp)
	FILE   *fp;
{
	register int x, y;
	Sector *mp;
	Value  *vp;
	char    buf[BUFSIZ];
	int     val;

	while (fgets(buf, sizeof buf, fp) != NULL) {
		x = xoffset(atoi(buf));
		y = yoffset(atoi(&buf[4]));
		val = atoi(&buf[8]);
		maxxy(x, y);
		mp = map[x][y];
		if (mp == NULL)
			map[x][y] = mp = newmap();
		if (mp->vp == NULL)
			mp->vp = newval();
		vp = mp->vp;
		mp->own = 1;
		vp->val[SPECIAL] = val;
		vp->val[COU] = -1;
	}
}
