
/* map.c - map routines */

/*
 * $Log:	map.c,v $
 * Revision 1.5  89/02/22  20:02:23  muir
 * indent and lint processed
 * replaced 128 with MAPSIZE
 * 
 * Revision 1.4  88/08/15  19:18:20  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/map.c,v 1.5 89/02/22 20:02:23 muir Exp $";
#endif

# include	"ve.h"

/*
 * readmap - Read and process the map file.  This is a real kludge where you
 *           try to figure out where you are on the map by looking at the
 *           coordinates along the edge of the map.
 */
readmap(fp)
	FILE   *fp;
{
	register int x, y;		    /* x,y map coordinates */
	register int transx, transy;	    /* transformed x,y */
	int     sign;			    /* Sign of number being
					     * converted */
	char    minb[5];		    /* Number buffers for
					     * min and max x */
	char    maxb[5];
	char   *sp = minb;
	char   *lp = maxb;
	char   *bp;
	char    buf[BUFSIZ];

	while ((bp = fgets(buf, sizeof buf, fp)) != NULL)
		if (*bp != '\n')
			break;
	/* Now determine the minimum x value */
	*sp++ = buf[4];
	*lp++ = buf[strlen(buf) - 2];
	sign = (index(buf, '-')) ? -1 : 1;
	fgets(buf, sizeof buf, fp);
	*sp++ = buf[4];
	*lp++ = buf[strlen(buf) - 2];
	*sp = 0;
	*lp = 0;

	minx = atoi(minb);
	maxx = atoi(maxb);

	if (sign == -1) {
		if (minx > 0)
			minx *= -1;
	} else {
		if (minx > maxx) {
			maxx *= -1;
			minx *= -1;
		}
	}

	fgets(buf, sizeof buf, fp);
	miny = atoi(buf);

	for (y = miny; buf[2] != ' '; y++) {
		transy = yoffset(y);
		for (bp = &buf[4], x = minx;
		     x <= maxx; x++, bp++) {
			transx = xoffset(x);
			if (*bp != ' ') {
				merge(*bp, transx, transy, FALSE);
				maxxy(transx, transy);
			}
		}
		fgets(buf, sizeof buf, fp);
	}
}
/*
 * mapdr - Display map.
 */
mapdr(sflg)
	register int sflg;
{
	register int x, y;
	register int tx, ty;
	register char des;
	register Sector *mp;

	for (y = starty, ty = yoffset(y);
	     y <= starty + MLINES; y++, ty = (++ty) % MAPSIZE)
		for (x = startx, tx = xoffset(x);
		     x <= startx + MCOLS; x++, tx = (++tx) % MAPSIZE) {
			mvaddch(y - starty, x - startx, ' ');
			if (!VALID(x, y))
				continue;
			mp = map[tx][ty];
			if (mp == NULL)
				continue;
			if (shipmode && mp->shp != NOSHIPS)
				des = ships[mp->shp]->des;
			else if (planemode && mp->pln != NOPLANES)
				des = planes[mp->pln]->des;
			else if (sflg && mp->surv)
				des = mp->surv;
			else
				des = mp->des;
			mvaddch(y - starty, x - startx - 1,
				(mp->mark) ? mp->mark : ' ');
			if (des) {
				if (mp->own == 2)
					standout();
				mvaddch(y - starty, x - startx, des);
				if (mp->own == 2)
					standend();
			}
		}
}
