
/* cutoff.c - delivery threshold level routines */

/*
 * $Log:	cutoff.c,v $
 * Revision 1.6  89/02/22  20:00:54  muir
 * indent and lint processed
 * 
 * Revision 1.5  88/11/21  19:07:21  muir
 * after rynes patch 01
 * (cargo command)
 *
 * Revision 1.4  88/08/15  19:18:06  muir
 * cleand up the headers
 *
 *
 */

#ifndef lint
static char Rcsid[] = "@(#) $Header: /usr6/postgres/muir/empire/client/ve/RCS/cutoff.c,v 1.6 89/02/22 20:00:54 muir Exp $";
#endif

#include "ve.h"

Level  *newlev();

cutoff(fp)
	FILE   *fp;
{
	register int x, y;
	register int nx, ny;
	char    buf[BUFSIZ];
	Sector *mp;
	Level  *lp;
	Value  *vp;

	while (fgets(buf, sizeof buf, fp) != NULL) {
		if (buf[3] != ',')
			continue;
		x = atoi(buf);
		y = atoi(&buf[4]);
		nx = xoffset(x);
		ny = yoffset(y);
		maxxy(nx, ny);
		mp = map[nx][ny];
		if (mp == NULL)
			map[nx][ny] = mp = newmap();
		if (mp->vp == NULL)
			mp->vp = newval();
		vp = mp->vp;
		vp->val[DES] = merge(buf[8], nx, ny, TRUE);
		lp = mp->lp;
		if (lp == NULL)
			mp->lp = lp = newlev();
		sscanf(&buf[10], "%c%c%c%c%c%c%c%c%c%c%c%c",
		       &vp->del[UW], &vp->del[FOOD],
		       &vp->del[SH], &vp->del[GUN], &vp->del[PET],
		       &vp->del[IRON], &vp->del[DUST], &vp->del[BAR],
		       &vp->del[CRU], &vp->del[LCM], &vp->del[HCM],
		       &vp->del[RAD]);
		sscanf(&buf[22], "%hd%hd%hd%hd%hd%hd%hd%hd%hd%hd%hd%hd",
		       &lp->cutoff[UW], &lp->cutoff[FOOD],
		       &lp->cutoff[SH], &lp->cutoff[GUN],
		       &lp->cutoff[PET], &lp->cutoff[IRON],
		       &lp->cutoff[DUST], &lp->cutoff[BAR],
		       &lp->cutoff[CRU], &lp->cutoff[LCM],
		       &lp->cutoff[HCM], &lp->cutoff[RAD]);
	}
}
