
# awk script that reads telegrams and keeps track of terrorist 
# activities.
#
# it must input and output from a file with the following format:
#
# terror
# -
# -
#  sect   (each line must 17 chars, NO TABS )
# END-OF-TERROR
#

BEGIN	{
	ing = 1
	inb = 0
	inc = 0
}
inc == 1 && NF == 16 {
	CEN[$1] = "-"
}
inc == 1 && NF == 17 {
	CEN[$1] = "*"
}
inb == 1 && $1 == "Sector" && $5 == "fully" && NF == 6 {
	ST[$2] = "CLEARED"
}
inb == 1 && $1 == "Terrorists" && $2 == "blew" && $NF == "damage" {
	if (ST[$4] == "LOST" && CEN[$4] != "-" && CEN[$4] != "*") next
	ST[$4] = "BLEW"
	ingw = 0
}
inb == 1 && $1 == "Guerrilla" && $2 == "warfare" && NF == 4 {
	if (ST[$4] == "LOST" && CEN[$4] != "-" && CEN[$4] != "*") next
	ingw = 1
	ST[$4] = "LOSING"
	sct = $4
	next
}
ingw == 1 && $1 == "body" {
	if ($NF != "0") ST[sct] = "WINNING"
	if ($NF > substr($4,1,length($4)-1)) ST[sct] = "WAR"
	ingw = 0
}
inb == 1 && $1 == "Lost" && $2 == "contact" && NF == 5 {
	ST[substr($NF,1,length($NF)-1)] = "LOST"
}
inb == 1 && $1 == "Revolutionary" && $2 == "subversion" && NF == 5 {
	sct = substr($NF,1,length($NF)-1)
	if (length(SCT[sct]) < 2) SCT[sct] = "SUBVERSION"
}
inb == 1 && $1 == "Telegram" {
	inb = 0
	ing = 0
	ingw = 0
	inc = 0
}

inb == 1 && /^$/ {
	inb = 0
}
ing == 1 && /END-OF-TERROR/ {
	ing = 0
	inc = 1
}
ing == 1 && NF == 2 {
	ST[$1] = $2
}
$1 == "BULLETIN!" {
	inb = 1
	ing = 0
	inc = 0
}
END	{
	print "terror"
	print "-"
	print "-"
	print " sect   (each line must 17 chars, NO TABS )"
	for (i in ST) {
		if (ST[i] != "CLEARED" && CEN[i] != "-")
			print i"                            "ST[i]
	}
	for (i in CEN) {
		if (CEN[i] == "*" && ST[i] == "") 
			print i"                            NEW"
	}
	print "END-OF-TERROR"
}
