
# 
# this awk script reads an empire map (low x must be on the left side)
# and writes out sector data in the form "x y des".  makemap.awk can
# reverse this.
#

BEGIN	{ phase = 0 }

phase == 1 {
	j = -1
	for (i = 1; i <= length($0); i++) {
		if (j == -1) {
			if (substr($0,i,1) != " ") {
				j = i
			} 
		}
	}
	if (ind == -1) {
		ind = j
		lowx = substr($0,ind,1)
		highx =substr($0,length,1)
	} else {
		if (ind == j) {
			lowx = lowx "" substr($0,ind,1)
			highx = highx "" substr($0,length,1)
		} else {
			phase = 2

			# three cases:
			#	both are negative
			#	one is negative, one is positive
			#	both are positive

			lx = lowx +0
			hx = highx +0
			ln = length -ind -3

			if (lx + hx == ln) {
				# one negative, one positive
				lx = -lx
				hx = hx
			}

			if (lx - hx == ln) {
				# both negative
				lx = -lx
				hx = -hx
			}

			# print "DATA: "lowx" to "highx" (" ln "): "lx","hx
		}		
	}
}

phase == 2 {	
	j = -1
	for (i = 1; i <= length($0); i++) {
		if (j == -1) {
			if (substr($0,i,1) != " ") {
				j = i
			} 
		}
	}
	if (j == ind) {
		phase = 3
	} else {
		e = length($0)-length($NF)
		for (i = ind; i <= e; i++) {
			c = substr($0,i,1)
			if (c != " ") print lx-ind+i" "$1" "substr($0,i,1)
		}
	}
}

phase == 3 {
	j = -1
	for (i = 1; i <= length($0); i++) {
		if (j == -1) {
			if (substr($0,i,1) != " ") {
				j = i
			} 
		}
	}
	if (j != ind) {
		phase = 0
	}
}

phase == 0 && /map/	{ 
	phase = 1; ind = -1 
	next 
}
