
#
# this awk script builds a mil/civ threshold file to be used by 
# manage (../dillon/manage.c)
#
# it reads a terroism file built by terrorist.awk, a plage file built
# by plague.awk and a census.
#
# it contains some country specific rules.
#

/^terror/	{ ter = 1 ; xl = 0; pl = 0; ce = 0}
/^xlev/		{ ter = 0 ; xl = 1; pl = 0; ce = 0}
/^plague/	{ ter = 0 ; xl = 0; pl = 1; ce = 0}
/^cen/		{ ter = 0 ; xl = 0; pl = 0; ce = 1}
NF == 1		{ next }

ce == 1 && NF == 16 {
	des[$1] = $2 ; mob[$1] = $4; civ[$1] = $7; mil[$1] = $8; wk[$1] = $9
	eff[$1] = $3 ; foo[$1] = $10
	}

ce == 1 && NF == 17 {
	des[$1] = $2 ; mob[$1] = $4; civ[$1] = $8; mil[$1] = $9; wk[$1] = $10
	captured[$1] = 1 ; eff[$1] = $3; foo[$i] = $11
	}

ter == 1 && $2 == "NEW"		 { newmil[$1] = wk[$2] / 11 + 10 }
ter == 1 && $2 == "BLEW"	 { newmil[$1] = mil[$2] * 2 + 20 }
ter == 1 && $2 == "WINNING"	 { newmil[$1] = wk[$1] / 100 + 10 }
ter == 1 && $2 == "WAR"		 { newmil[$1] = wk[$1]/11 + 25 }
ter == 1 && $2 == "LOSING"	 { newmil[$1] = wk[$1]/11 + 50 }
ter == 1 && $2 == "SUBVERSION"	 { newmil[$1] = wk[$1]/15 + 30 }

xl == 1 && $1 != "sects" {
	oldciv[$1] = $(NF-1)
	oldmil[$1] = $NF
}

pl == 1 && $2 == "BATTLE" { if (des[$1] != "^") newciv[$1] = 959 }

END {
	print "xlev\n-\n-\n sects      civ mil"

	for (i in des) {
	 	c = civ[i]; m = 0; d = substr(des[i],length(des[i]))

		if (civ[i] >999)   { cc = 999 } else { cc = civ[i] }

		if (d == "f")			{ c = 600; m = 100 }
		if (d == ")")			{ c = 600; m = 20 }
		if (d != des[i] || eff[i] != "100%")	{ c = 959 }

		if (d == "c")			{ c = 959; m = 30 }
		if (i == "0,0")			{ c = 7000; m = 100 }
		if (d == "e")      		{ c = 959; m = civ[i] * .2 }
		if (d == "*")			{ c = 959; m = 100 }
		if (d == "h")			{ c = 959; m = 150 }
		if (i == "13,-5" && d == "*")   { c = 1200; m = 200 }

		if (d == "m" || d == "i" || d == "d" || d == "=") { c = 959 }
		if (d == "l" || d == "j" || d == "k" || d == "p") { c = 959 }
		if (d == "r" || d == "t" || d == "u" || d == "o") { c = 959 }
		if (d == "g" || d == "+" || d == "#")             { c = 959 }

		if (newciv[i] > c) { c = newciv[i] }
		if (newmil[i] > m) { m = newmil[i] }

		if (m == 0 && mil[i] < cc/60) { m = cc/99 }

		if (mil[i] > m && (d == "f"||d == "*"||d == "c"||mob[i] < 50)){
			m = mil[i]
		}

		if (c > 959 && c < 999) { c = 959 }
		if (c < civ[i] && mob[i] < 100) { c = civ[i] }

		if (m < mil[i] - 60) { m = mil[i] - 60 }

		if (captured[i] == 1 && c < civ[i]) { c = civ[i] }

		if (foo[i] < 40 && c > 500) { c = civ[i] }
			
		if (m > 999) { m = 500 ; print "Sanity" >>"ERROR"  }
		printf "%-8s%-2s %4d  %3d\n",i,des[i],c,m
	}
}
