
# 
# given data of the form "x y des" this awk script will turn in into
# a map
#
# if there is a line in there "'transform' x y" then it will add x, y,
# to all of the following data before incorperating it.
#

BEGIN	{
	xt = 0
	yt = 0
	maxx = -9999
	maxy = -9999
	minx = 9999
	miny = 9999
}

$1 == "transform" {
	xt = $2
	yt = $3
	next
	}

NF == 3	{
	x = xt + $1
	y = yt + $2
	while (x < -64) { x += 128 }
	while (x > 63)  { x -= 128 }
	while (y < -64) { y += 128 }
	while (y > 63)  { y -= 128 }

	if (x > maxx) maxx = x
	if (x < minx) minx = x
	if (y > maxy) maxy = y
	if (y < miny) miny = y
	ov = map[x*128+y]
	if ((ov == "." && $3 == "-") || (ov == "-" && $3 == ".")) {
		print "Error. "x","y" redefined" >"ERRORS"
	}
	map[x*128+y] = $3
	}

END	{
	print "map "minx":"maxx","miny":"maxy
	hl1 = ""
	hl2 = ""
	for (i = minx; i <= maxx ; i ++) {
		c = (i%10)
		if (c < 0) c = -c
		hl2 = hl2 "" c
		if (i < -9) {
			c = (int(-i / 10)) 
			hl1 = hl1 "" c
			continue
		}
		if (i >= 0) {
			c = (int(i/10))
			hl1 = hl1 "" c 
			continue
		}
		hl1 = hl1 "-" 
	}
	print "    "hl1
	print "    "hl2

	for (i = miny; i <= maxy ; i ++) {
		ln = ""
		printf "%3d ", i
		for (j = minx; j <= maxx; j++) {
			d = map[j*128+i]
			if (d == 0 && d == "")	ln = ln " "
			else 			ln = ln "" d 
		}
		printf "%s %d\n", ln, i
	}

	print "    "hl1
	print "    "hl2
}
