;# Empire data initialization routines.
;# Parse the command arguments, which should be output files
;# from (so far) nation, commodity, and census.  After they
;# are all parsed, read in each file and store the data.

#include "nation.perl"
#include "cencom.perl"
#include "version.perl"

;# Usage: do empinit('nation', 'census') -- or whatever files
;# are needed.

sub empinit {
    local($file, $command, $need);

    # Figure out the types of all the files passed as arguments.
    while ($file = shift) {
	open(file, $file);
	@filetype = split(' ', <file>);
	$command = $filetype[0];
	if ($command =~ /^nat/) {$NATION = $file;}
	elsif ($command =~ /^com/) {$COMMOD = $file;}
	elsif ($command =~ /^cen/) {$CENSUS = $file;}
	elsif ($command =~ /^ver/) {$VERSION = $file;}
	else {die "Unknown file type of $file: $command";}
    }

    # Read in the files we need.
    while ($need = shift(@_)) {
	if ($need =~ /^nat/) {
	    open(nation, $NATION) || die "Couldn't open nation file: $NATION";
	    do nation();
	    print "Read in nation file.\n";
	    next;
	}
	if ($need =~ /^cen/) {
	    open(census, $CENSUS) || die "Couldn't open census file: $CENSUS";
	    do census();
	    print "Read in census file.\n";
	    next;
	}
	if ($need =~ /^com/) {
	    open(commod, $COMMOD) || die 
		    "Couldn't open commodity file: $COMMOD";
	    do commod();
	    print "Read in commod file.\n";
	    next;
	}
	if ($need =~ /^ver/) {
	    open(version, $VERSION) || 
		    die "Couldn't open version file: $VERSION";
	    do version();
	    print "Read in version file.\n";
	    next;
	}
    }
}
