;# Census columns
#define SECTOR 0
#define OCCUP 'a'
#define SECTYPE 1
#define EFF 2
#define MOB 3
#define DEL_UF 4
#define DST_UF 5
#define CIV 6
#define MIL 7
#define UW 8
#define FOOD 9
#define MIN 10
#define GOLD 11
#define FERT 12
#define OIL 13
#define URAN 14
#define WORK 15

;# Read in the census file.
sub census {
    local($occup);

    # Ignore the first few lines.
    <census>;	# census #0
    <census>;	# Tue Aug  2 17:05:29 1988
    <census>;	# CENSUS              del dst
    <census>;	#   sect      eff mob  uf  uf   civ mil  uw ...

    while (<census>) {

	if (eof) {last;}	# Skip '# sectors' line

	# Check if there are stars (occupied enemy sectors), 
	# and if so, replace the star with a space so the 
	# split() will always have the right number of fields.
	$occup = s/\*/ /;
	    
	@stuff = split(' ');
	$sector = $stuff[SECTOR];

	# Assign each sector value

	# (Properly, should be $sectors{$sector, OCCUP} = ..,
	#  but multidim. assoc. arrays don't work yet.)
	$sectors{$sector, OCCUP} = $occup;
	$sectors{$sector, SECTYPE} = $stuff[SECTYPE];
	$sectors{$sector, EFF} = $stuff[EFF];
	$sectors{$sector, MOB} = $stuff[MOB];
	$sectors{$sector, DEL_UF} = $stuff[DEL_UF];
	$sectors{$sector, DST_UF} = $stuff[DST_UF];
	$sectors{$sector, CIV} = $stuff[CIV];
	$sectors{$sector, MIL} = $stuff[MIL];
	$sectors{$sector, UW} = $stuff[UW];
	$sectors{$sector, FOOD} = $stuff[FOOD];
	$sectors{$sector, MIN} = $stuff[MIN];
	$sectors{$sector, GOLD} = $stuff[GOLD];
	$sectors{$sector, FERT} = $stuff[FERT];
	$sectors{$sector, OIL} = $stuff[OIL];
	$sectors{$sector, URAN} = $stuff[URAN];
	$sectors{$sector, WORK} = $stuff[WORK];

	# Save a list of all the sectors for fast lookup.
	push(@sec_list, $sector);
    }
}

;# Test function to make sure the data is being read in correctly.
sub test_census {
    local($sec);

    print "Capital efficiencies:\n";
    foreach $sec (@sec_list) {
	if ($sectors{$sec, SECTYPE} eq 'c') {
	    print "$sec: ", $sectors{$sec, EFF}, "\n";
	}
    }
}


;# The rest of this file is about the same as above, only for commodity
;# stuff..
#define CSECTOR 0
#define CSECTYPE 1
#define CDEL 2
#define CDIST 3
#define CSH 4
#define CGUN 5
#define CPET 6
#define CIRON 7
#define CDUST 8
#define CBAR 9
#define COIL 10
#define CLCM 11
#define CHCM 12
#define CRAD 13

sub commod {
    <commod>;	# census #0
    <commod>;	# Tue Aug  2 17:05:29 1988
    <commod>;	# COMMODITIES deliver-- distribute
    <commod>;	#  sect     sgpidbolhr sgpidbolhr  sh  gun  pet iron ...
    while (<commod>) {
	if (eof) {last;}	# Skip '# sectors' line

	@stuff = split(' ');
	$sector = $stuff[CSECTOR];
	$csectors{$sector, CSECTYPE} = $stuff[CSECTYPE];
	$csectors{$sector, CDEL} = $stuff[CDEL];
	$csectors{$sector, CDIST} = $stuff[CDIST];
	$csectors{$sector, CSH} = $stuff[CSH];
	$csectors{$sector, CGUN} = $stuff[CGUN];
	$csectors{$sector, CPET} = $stuff[CPET];
	$csectors{$sector, CIRON} = $stuff[CIRON];
	$csectors{$sector, CDUST} = $stuff[CDUST];
	$csectors{$sector, CBAR} = $stuff[CBAR];
	$csectors{$sector, COIL} = $stuff[COIL];
	$csectors{$sector, CLCM} = $stuff[CLCM];
	$csectors{$sector, CHCM} = $stuff[CHCM];
	$csectors{$sector, CRAD} = $stuff[CRAD];
    }
}

sub test_commod {
    local($dust);

    print "Sectors with dust:\n";
    foreach $sec (@sec_list) {
	$dust = $csectors{$sec, CDUST};
	if ($dust) {
	    print "$sec: $dust\n";
	}
    }
}
