static char *RCSid = "$Header: sendserver.c,v 1.6 88/07/20 11:40:29 muir Locked $";

/*
 * $Log:	sendserver.c,v $
 * Revision 1.6  88/07/20  11:40:29  muir
 * after jpo patch 18
 *  empire fixed to filter out standout characters when writing to a file
 * and to stop core dumping if EMPIREPORT is undefined.
 * 
 * Revision 1.5  88/04/01  04:41:11  muir
 * rcsid now at top
 * 
 */

/*
 * sendserver.c
 *
 * Dave Pare, 1986
 */

#include <ctype.h>
#include <stdio.h>
#include "defs.h"
#include "sailio.h"
#include "fnlist.h"

void
sendserver(val, str)
	int	val;
	char	*str;
{
	extern	struct fn fnlist[];
	extern	SAIL *iop;
	char	buf[255];

	if (val >= 0 && str != NULL)
		(void) sprintf(buf, "%s %s\n", fnlist[val].name, str);
	else if (val >= 0)
		(void) sprintf(buf, "%s\n", fnlist[val].name);
	(void) sputs(buf, iop);
	(void) sflush(iop);
}

char	recvbuf[4096];
char	*SO;
char	*SE;


char *
recvserver(val, msg)
	int	*val;
	char	*msg;
{
	extern	SAIL *iop;
	register char *mp;
	char	cmd[5];
	char	*bufp;
	char	*bp;
	int	i;
	char	*sop;
	char	c;
	extern FILE	*redir_fp;

	*msg = 0;
	(void) sgets(recvbuf, sizeof(recvbuf), iop, 90000);
	if (sio_conn(iop))
		return 0;
	bufp = recvbuf;
	bp = cmd;
	for (i=0; i<4; i++)
		*bp++ = *bufp++;
	*bp = 0;
	*val = atoi(cmd);
	mp = msg;
	while (c = *bufp++) {
		if (c & 0x80) {
			if (SO && !redir_fp)
				for (sop = SO; *mp = *sop++; mp++)
					;
			*mp++ = c & 0x7f;
			if (SE && !redir_fp)
				for (sop = SE; *mp = *sop++; mp++)
					;
		} else
			*mp++ = c;
	}
	*mp = 0;
	return msg;
}

parsedelay(r)
	char *r;
{
	char *s, *t;

	s = r;
	while (isdigit(*s) || (*s == '*') || (*s == '.')) {
		s++;
	}
	for (t = r; *s != 0; (s++, t++)) {
		*t = *s;
	}
	*t = 0;
}

void
getsose()
{
	extern	char *getenv();
	extern	char *tgetstr();
	static	char tbuf[1024];
	static	char cbuf[20];
	char	*cp;
	char	*term;

	term = getenv("TERM");
	if (term == 0) {
		printf("can't find your term type!\n");
		return;
	}
	tgetent(tbuf, term);
	cp = cbuf;
	SO = tgetstr("so", &cp);
	SE = tgetstr("se", &cp);
	if (SO == 0) {
		SO = tgetstr("us", &cp);
		SE = tgetstr("ue", &cp);
	}
	if (SO != 0) {
		parsedelay(SO);
		parsedelay(SE);
	}
}
